import type { FC, ReactNode } from 'react';
import { getBoxArtSrcAndSrcSet } from 'tachyon-more-ui';
import type { CoreImageSize, CoreLinkProps } from 'twitch-core-ui';
import {
  AlignSelf,
  AspectRatio,
  Card,
  CardBody,
  CardImage,
  CardImageSize,
  Color,
  CoreLink,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  JustifyContent,
  Layout,
  Overflow,
} from 'twitch-core-ui';
import type { TachyonLinkPublicProps } from '../../../../routing';
import { RouteName, renderTachyonLink } from '../../../../routing';

export interface GameCardRowProps
  extends Pick<
      TachyonLinkPublicProps<RouteName.GameDirectory>,
      'interactionContent'
    >,
    Pick<CoreLinkProps, 'onClick'> {
  boxArtURL: string | null;
  details: ReactNode;
  gameName: string;
  srcSetSizes: CoreImageSize[];
  tagContainer: JSX.Element | null;
}

// istanbul ignore next: trivial
export const GameCardRow: FC<GameCardRowProps> = ({
  boxArtURL,
  details,
  gameName,
  interactionContent,
  onClick,
  srcSetSizes,
  tagContainer,
}) => {
  const linkToGame = renderTachyonLink({
    interactionContent,
    route: RouteName.GameDirectory,
    routeParams: { gameAlias: gameName },
  });

  return (
    <CoreLink
      linkTo="/deferToRenderLink"
      onClick={onClick}
      renderLink={linkToGame}
    >
      <Card row>
        <Layout alignSelf={AlignSelf.Center} display={Display.Flex}>
          <CardImage
            alt=""
            aspect={AspectRatio.Aspect3x4}
            size={CardImageSize.Size8}
            sizes={srcSetSizes}
            {...getBoxArtSrcAndSrcSet(boxArtURL)}
          />
        </Layout>
        <CardBody overflow={Overflow.Hidden}>
          <Layout
            display={Display.Flex}
            flexDirection={FlexDirection.Column}
            justifyContent={JustifyContent.Between}
            padding={{ left: 1 }}
          >
            <CoreText
              bold
              color={Color.Base}
              fontSize={FontSize.Size4}
              lines={2}
            >
              {gameName}
            </CoreText>
            <CoreText color={Color.Alt} ellipsis fontSize={FontSize.Size5}>
              {details}
            </CoreText>
            {tagContainer}
          </Layout>
        </CardBody>
      </Card>
    </CoreLink>
  );
};

GameCardRow.displayName = 'GameCardRow';
