import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { mockGameCardQuery } from '../test-mocks';
import { GameCardPoster } from './GameCardPoster';
import { GameCardRow } from './GameCardRow';
import { GameCardCommonBase } from '.';

describe(GameCardCommonBase, () => {
  const setup = createShallowWrapperFactory(GameCardCommonBase, () => ({
    game: mockGameCardQuery(),
    hideTags: false,
    srcSetSizes: [],
  }));

  it('renders cards when given default props', () => {
    const { wrapper } = setup();
    expect(wrapper.find(GameCardPoster)).toExist();
    expect(wrapper.find(GameCardRow)).not.toExist();
  });

  it('renders tags', () => {
    const { wrapper } = setup();
    expect(wrapper.find(GameCardRow)).not.toExist();
    expect(wrapper.find(GameCardPoster)).toExist();
    expect(wrapper.find(GameCardPoster).prop('tagContainer')).toBeDefined();
  });

  it('hides tags', () => {
    const { wrapper } = setup({ hideTags: true });
    expect(wrapper.find(GameCardRow)).not.toExist();
    expect(wrapper.find(GameCardPoster)).toExist();
    expect(wrapper.find(GameCardPoster).prop('tagContainer')).toBeNull();
  });

  it('renders GameCardRow when prop gets passed', () => {
    const { wrapper } = setup({ showMoreDetails: true });
    expect(wrapper.find(GameCardPoster)).not.toExist();
    expect(wrapper.find(GameCardRow)).toExist();
    expect(wrapper.find(GameCardRow).prop('tagContainer')).toBeDefined();
  });
});
