import type { FC } from 'react';
import { memo } from 'react';
import type { IntlProps } from 'tachyon-intl';
import { withIntl } from 'tachyon-intl';
import {
  AlignItems,
  Color,
  CoreText,
  Display,
  FontSize,
  JustifyContent,
  Layout,
  TextAlign,
} from 'twitch-core-ui';

export interface NoChannelsLiveProps extends IntlProps {
  game?: string;
  hasTags?: boolean;
}

export const NoChannelsLiveBase: FC<NoChannelsLiveProps> = ({
  game,
  hasTags,
  intl: { formatMessage },
}) => (
  <Layout
    alignItems={AlignItems.Center}
    display={Display.Flex}
    fullWidth
    justifyContent={JustifyContent.Center}
    padding={{ top: 5 }}
    textAlign={TextAlign.Center}
  >
    <CoreText color={Color.Base} fontSize={FontSize.Size4}>
      {hasTags
        ? formatMessage(
            "No results found. Try adjusting your tags to find what you're looking for.",
            'NoChannelsLive',
          )
        : formatMessage(
            'There are no channels currently live for {game}.',
            {
              game: game ?? 'Twitch',
            },
            'NoChannelsLive',
          )}
    </CoreText>
  </Layout>
);

NoChannelsLiveBase.displayName = 'NoChannelsLiveBase';

export const NoChannelsLive = memo(withIntl(NoChannelsLiveBase));
