import { DefaultTwitchIntl } from 'tachyon-intl';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { NoChannelsLiveBase } from '.';

describe(NoChannelsLiveBase, () => {
  const setup = createShallowWrapperFactory(NoChannelsLiveBase, () => ({
    intl: DefaultTwitchIntl,
  }));

  it('renders generic text when tags are present', () => {
    const { wrapper } = setup({ hasTags: true });
    expect(wrapper.find(CoreText).props().children).toContain(
      "No results found. Try adjusting your tags to find what you're looking for.",
    );
  });

  it('renders message of no channels for specific game', () => {
    const { wrapper } = setup({ game: 'GTA' });
    expect(wrapper.find(CoreText).props().children).toContain(
      'There are no channels currently live for GTA.',
    );
  });
});
