import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Card } from 'twitch-core-ui';
import { mockStreamCardQuery } from '../test-mocks';
import { StreamCardCommonBase } from '.';

describe(StreamCardCommonBase, () => {
  const setup = createShallowWrapperFactory(StreamCardCommonBase, () => ({
    srcSetSizes: [],
    stream: {
      ...mockStreamCardQuery(),
    },
  }));

  it('renders empty when there is no broadcaster', () => {
    const { wrapper } = setup({
      stream: { broadcaster: null },
    });
    expect(wrapper.find(Card)).toHaveLength(0);
  });

  it('renders a card when given correct props', () => {
    const { wrapper } = setup();

    expect(wrapper.find(Card)).toHaveLength(1);
  });
});
