import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { formatVideoLength } from 'tachyon-utils';
import { CoreLink } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../routing';
import { VideoRowItemCommon } from '../VideoRowItemCommon';
import type { VideoRowItem_video } from './__generated__/VideoRowItem_video.graphql';

export interface VideoRowItemProps {
  interactionContent: string;
  video: VideoRowItem_video;
}

// istanbul ignore next: trivial
export const VideoRowItemBase: FC<VideoRowItemProps> = ({
  interactionContent,
  video,
}) => (
  <CoreLink
    linkTo="/deferToRenderLink"
    renderLink={renderTachyonLink({
      interactionContent,
      route: RouteName.Vod,
      routeParams: { videoID: video.id },
    })}
  >
    <VideoRowItemCommon
      createdAt={video.createdAt ? new Date(video.createdAt) : null}
      formattedLength={
        video.lengthSeconds ? formatVideoLength(video.lengthSeconds) : null
      }
      gameName={video.game?.name ?? null}
      imageURL={video.previewThumbnailURL}
      title={video.title}
      viewCount={video.viewCount}
    />
  </CoreLink>
);

VideoRowItemBase.displayName = 'VideoRowItemBase';

export const VideoRowItem = createFragmentContainer(VideoRowItemBase, {
  video: graphql`
    fragment VideoRowItem_video on Video {
      id
      title
      previewThumbnailURL
      viewCount
      lengthSeconds
      createdAt
      game {
        id
        name
      }
    }
  `,
});
