import Faker from 'faker';
import type { GameCardCommon_game } from './GameCardCommon';
import type { StreamCardCommon_stream } from './StreamCardCommon';

export function mockGameCardQuery(): GameCardCommon_game {
  return {
    ' $fragmentRefs': { TagList_game: true },
    ' $refType': 'GameCardCommon_game',
    boxArtURL:
      'https://static-cdn.jtvnw.net/ttv-boxart/World%20of%20Warcraft-{width}x{height}.jpg',
    displayName: 'World of Warcraft',
    followersCount: 123,
    name: 'World of Warcraft',
    viewersCount: 73135,
  };
}

export function mockStreamCardQuery(): StreamCardCommon_stream {
  return {
    ' $fragmentRefs': { TagList_stream: true },
    ' $refType': 'StreamCardCommon_stream',
    broadcaster: {
      broadcastSettings: { title: Faker.lorem.words(5) },
      displayName: Faker.lorem.words(5),
      hosting: null,
      id: Faker.datatype.uuid(),
      login: 'foo',
      profileImageURL: Faker.internet.url(),
    },
    game: { id: Faker.datatype.uuid(), name: Faker.lorem.words(5) },
    id: Faker.datatype.uuid(),
    previewImageURL: Faker.internet.url(),
    type: 'live',
    viewersCount: 1,
  };
}
