import type { FC } from 'react';
import { BranchRoot } from 'react-branch';
import { useStaticEnvironment } from 'tachyon-environment';
import { BRANCH_PROD_KEY, BRANCH_TEST_KEY } from '../../../config';

export interface TomorrowBranchRootProps {
  isDebug?: boolean;
}

export const TomorrowBranchRoot: FC<TomorrowBranchRootProps> = ({
  children,
  isDebug,
}) => {
  const { client } = useStaticEnvironment();

  return (
    <BranchRoot
      apiKey={isDebug ? BRANCH_TEST_KEY : BRANCH_PROD_KEY}
      initOptions={
        client.deviceID
          ? {
              metadata: { device_id: client.deviceID },
              tracking_disabled: true,
            }
          : { tracking_disabled: true }
      }
    >
      {children}
    </BranchRoot>
  );
};

TomorrowBranchRoot.displayName = 'TomorrowBranchRoot';
