import { BranchRoot } from 'react-branch';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { BRANCH_PROD_KEY, BRANCH_TEST_KEY } from '../../../config';
import { TomorrowBranchRoot } from '.';

describe(TomorrowBranchRoot, () => {
  const setup = createShallowWrapperFactory(TomorrowBranchRoot, () => ({
    isDebug: false,
  }));

  it('sets correct api key', () => {
    expect(setup().wrapper.find(BranchRoot)).toHaveProp(
      'apiKey',
      BRANCH_PROD_KEY,
    );

    expect(setup({ isDebug: true }).wrapper.find(BranchRoot)).toHaveProp(
      'apiKey',
      BRANCH_TEST_KEY,
    );
  });
});
