import { createMountWrapperFactory } from 'tachyon-test-utils';
import { BranchEvent } from '../useBranchTimedTracker';
import { TachyonBranchTimedTracker } from '.';

jest.mock('tachyon-environment', () => {
  const original = jest.requireActual('tachyon-environment');
  return {
    ...original,
    useStaticEnvironment: original.mockUseStaticEnvironment(),
  };
});

const mockTrackFn = jest.fn();
jest.mock('react-branch', () => ({
  ...jest.requireActual('react-branch'),
  useTracking: () => ({ track: mockTrackFn }),
}));

describe(TachyonBranchTimedTracker, () => {
  beforeEach(() => {
    mockTrackFn.mockReset();
  });

  const setup = createMountWrapperFactory(TachyonBranchTimedTracker, () => ({
    delaySecondsUntilTrack: 5,
    event: BranchEvent.FiveMinutePlay,
  }));

  it('sends the correct event at the correct time', () => {
    const { wrapper } = setup();
    expect(wrapper.html()).toBeNull();
    expect(mockTrackFn).not.toHaveBeenCalled();

    jest.runAllTimers();
    wrapper.update();
    expect(mockTrackFn).toHaveBeenCalledTimes(1);
    expect(mockTrackFn).toHaveBeenCalledWith(BranchEvent.FiveMinutePlay, {
      device_id: 'ios-safari-device',
      session_id: 'ios-safari-session',
    });
  });
});
