import { SUPPORTED_LANGUAGE_CODES } from 'tachyon-intl';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { BASE_MOBILE_URL, LANGUAGE_QUERY_PARAM_KEY } from '../../../../config';

interface AlternateLanguageTag {
  code: string;
  href: string;
}

export const useAlternateLanguageTags = (): AlternateLanguageTag[] => {
  const { currentAsPath } = useRouterUtils();
  const tags = SUPPORTED_LANGUAGE_CODES.map((code) => {
    const parsedURL = new URL(`${BASE_MOBILE_URL}${currentAsPath}`);
    parsedURL.searchParams.set(LANGUAGE_QUERY_PARAM_KEY, code);
    return { code, href: parsedURL.href };
  }).filter((item) => !!item.code);

  // https://developers.google.com/search/docs/advanced/crawling/localized-versions
  const url = new URL(`${BASE_MOBILE_URL}${currentAsPath}`);
  url.searchParams.delete(LANGUAGE_QUERY_PARAM_KEY);

  tags.push({
    code: 'x-default',
    href: url.href,
  });

  return tags;
};
