import { useRouterUtils } from 'tachyon-next-routing-utils';
import { useAlternateLanguageTags } from '.';

jest.mock('tachyon-next-routing-utils', () => ({
  useRouterUtils: jest.fn(),
}));

const mockUseRouterUtils = useRouterUtils as jest.Mock;

describe('useAlternateLanguageTags', () => {
  it('works for path: "/"', () => {
    mockUseRouterUtils.mockImplementationOnce(() => ({ currentAsPath: '/' }));

    expect(useAlternateLanguageTags()).toEqual(
      expect.arrayContaining([
        { code: 'de', href: 'https://m.twitch.tv/?lang=de' },
        { code: 'fr', href: 'https://m.twitch.tv/?lang=fr' },
        { code: 'x-default', href: 'https://m.twitch.tv/' },
      ]),
    );
  });

  it('works for path: "/username/videos"', () => {
    mockUseRouterUtils.mockImplementationOnce(() => ({
      currentAsPath: '/username/videos',
    }));

    expect(useAlternateLanguageTags()).toEqual(
      expect.arrayContaining([
        { code: 'de', href: 'https://m.twitch.tv/username/videos?lang=de' },
        { code: 'fr', href: 'https://m.twitch.tv/username/videos?lang=fr' },
        { code: 'x-default', href: 'https://m.twitch.tv/username/videos' },
      ]),
    );
  });

  it('keeps existing query param', () => {
    mockUseRouterUtils.mockImplementationOnce(() => ({
      currentAsPath: '/search?lang=fr&term=counter',
    }));

    expect(useAlternateLanguageTags()).toEqual(
      expect.arrayContaining([
        { code: 'de', href: 'https://m.twitch.tv/search?lang=de&term=counter' },
        { code: 'fr', href: 'https://m.twitch.tv/search?lang=fr&term=counter' },
        { code: 'x-default', href: 'https://m.twitch.tv/search?term=counter' },
      ]),
    );
  });
});
