import { useTracking } from 'react-branch';
import { useStaticEnvironment } from 'tachyon-environment';
import { useTimeout } from 'tachyon-utils';

export enum BranchEvent {
  FiveMinutePlay = '5mp',
}

export function useBranchTimedTracker(
  event: BranchEvent,
  delaySecondsUntilTrack: number,
): void {
  const {
    client: { deviceID, sessionID },
  } = useStaticEnvironment();
  const { track } = useTracking();

  useTimeout(() => {
    track(event, { device_id: deviceID, session_id: sessionID });
  }, delaySecondsUntilTrack * 1000);
}
