import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import styled from 'styled-components';
import { useIntl } from 'tachyon-intl';
import { getChannelBannerSrcAndSrcSet } from 'tachyon-more-ui';
import {
  AccentRegion,
  AlignItems,
  Background,
  CoreImage,
  Display,
  JustifyContent,
  Layout,
  Overflow,
  generateAccentRegionProps,
} from 'twitch-core-ui';
import type { ChannelCover_user } from './__generated__/ChannelCover_user.graphql';

export type ChannelCoverProps = {
  user: ChannelCover_user;
};

const ScImageWrapper = styled(Layout)`
  height: 9rem;
`;

export const ChannelCoverBase: FC<ChannelCoverProps> = ({ user }) => {
  const { formatMessage } = useIntl();
  let image: JSX.Element | null = null;
  if (user.bannerImageURL && user.login) {
    image = (
      <CoreImage
        alt={formatMessage(
          'Profile banner for {channelDisplayName}',
          {
            channelDisplayName: user.login,
          },
          'ChannelCover',
        )}
        sizes={[{ size: '100vw' }]}
        {...getChannelBannerSrcAndSrcSet(user.bannerImageURL)}
      />
    );
  }

  return (
    <AccentRegion {...generateAccentRegionProps(user.primaryColorHex)}>
      <ScImageWrapper
        alignItems={AlignItems.Center}
        background={Background.Accent}
        display={Display.Flex}
        elevation={3}
        justifyContent={JustifyContent.Center}
        overflow={Overflow.Hidden}
      >
        {image}
      </ScImageWrapper>
    </AccentRegion>
  );
};

ChannelCoverBase.displayName = 'ChannelCover';

export const ChannelCover = createFragmentContainer(ChannelCoverBase, {
  user: graphql`
    fragment ChannelCover_user on User {
      login
      bannerImageURL
      primaryColorHex
    }
  `,
});
