import { image } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreImage } from 'twitch-core-ui';
import { ChannelCoverBase } from '.';

describe('ChannelCover', () => {
  const setup = createShallowWrapperFactory(ChannelCoverBase, () => ({
    user: {
      ' $refType': 'ChannelCover_user',
      bannerImageURL: image.imageUrl(),
      login: 'foo',
      primaryColorHex: null,
    },
  }));

  it('renders image', () => {
    const { wrapper } = setup();
    expect(wrapper.find(CoreImage)).toExist();
  });

  it("doesn't render image if login is undefined", () => {
    const { wrapper } = setup({ user: { login: undefined } });
    expect(wrapper.find(CoreImage)).not.toExist();
  });

  it("doesn't render image if bannerImageURL is undefined", () => {
    const { wrapper } = setup({ user: { bannerImageURL: undefined } });
    expect(wrapper.find(CoreImage)).not.toExist();
  });
});
