import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { exhaustedCase } from 'tachyon-utils';
import { JustifyContent, Tabs } from 'twitch-core-ui';
import {
  RouteName,
  renderTachyonLink,
  routeNameFromPathname,
} from '../../../../routing';

type ChannelNavProps = {
  login: string;
};

type ChannelRoute =
  | RouteName.ChannelAbout
  | RouteName.ChannelClips
  | RouteName.ChannelHome
  | RouteName.ChannelSchedule
  | RouteName.ChannelVideos;

// istanbul ignore next: trivial
export const ChannelNav: FC<ChannelNavProps> = ({ login }) => {
  const { currentPathname } = useRouterUtils();
  const { formatMessage } = useIntl();

  const routeName = routeNameFromPathname(currentPathname) as ChannelRoute;

  let activeIndex = 0;
  switch (routeName) {
    case RouteName.ChannelHome:
      activeIndex = 0;
      break;
    case RouteName.ChannelAbout:
      activeIndex = 1;
      break;
    case RouteName.ChannelSchedule:
      activeIndex = 2;
      break;
    case RouteName.ChannelVideos:
      activeIndex = 3;
      break;
    case RouteName.ChannelClips:
      activeIndex = 4;
      break;
    default:
      exhaustedCase(routeName, 0);
  }

  return (
    <Tabs
      activeTabIndex={activeIndex}
      borderBottom={false}
      justifyContent={JustifyContent.Start}
      tabs={[
        {
          label: formatMessage('Home', 'ChannelNav'),
          linkTo: '/deferToRenderLink',
          renderLink: renderTachyonLink({
            route: RouteName.ChannelHome,
            routeParams: { login },
          }),
        },
        {
          label: formatMessage('About', 'ChannelNav'),
          linkTo: '/deferToRenderLink',
          renderLink: renderTachyonLink({
            route: RouteName.ChannelAbout,
            routeParams: { login },
          }),
        },
        {
          label: formatMessage('Schedule', 'ChannelNav'),
          linkTo: '/deferToRenderLink',
          renderLink: renderTachyonLink({
            route: RouteName.ChannelSchedule,
            routeParams: { login },
          }),
        },
        {
          label: formatMessage('Videos', 'ChannelNav'),
          linkTo: '/deferToRenderLink',
          renderLink: renderTachyonLink({
            route: RouteName.ChannelVideos,
            routeParams: { login },
          }),
        },
        {
          label: formatMessage('Clips', 'ChannelNav'),
          linkTo: '/deferToRenderLink',
          renderLink: renderTachyonLink({
            route: RouteName.ChannelClips,
            routeParams: { login },
          }),
        },
      ]}
    />
  );
};

ChannelNav.displayName = 'ChannelNav';
