import { datatype } from 'faker';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { ChannelDescriptionBase } from '.';

describe(ChannelDescriptionBase, () => {
  const setup = createMountWrapperFactory(ChannelDescriptionBase, () => ({
    user: {
      ' $refType': 'ChannelDescription_user',
      description: null,
      displayName: 'arthas',
      lastBroadcast: null,
      login: 'arthas',
      videos: null,
    },
  }));

  it('renders description if it exists', () => {
    const { wrapper } = setup({
      user: { description: 'mock description' },
    });

    expect(wrapper.find(CoreText)).toIncludeText('mock description');
  });

  it('uses last 1 video to figure out the last played game', () => {
    const { wrapper } = setup({
      user: {
        displayName: 'arthas',
        videos: {
          edges: [
            {
              node: {
                game: { displayName: 'World of Warcraft', id: datatype.uuid() },
                id: datatype.uuid(),
              },
            },
          ],
        },
      },
    });

    expect(wrapper.find(CoreText)).toIncludeText(
      'arthas streams World of Warcraft.',
    );
  });

  it('uses last 2 videos to figure out the last played games', () => {
    const { wrapper } = setup({
      user: {
        displayName: 'arthas',
        videos: {
          edges: [
            {
              node: {
                game: { displayName: 'World of Warcraft', id: datatype.uuid() },
                id: datatype.uuid(),
              },
            },
            {
              node: {
                game: { displayName: 'Hearthstone', id: datatype.uuid() },
                id: datatype.uuid(),
              },
            },
          ],
        },
      },
    });

    expect(wrapper.find(CoreText)).toIncludeText(
      'arthas streams World of Warcraft and Hearthstone.',
    );
  });

  it('uses last 3 videos to figure out the last played games', () => {
    const { wrapper } = setup({
      user: {
        displayName: 'arthas',
        videos: {
          edges: [
            {
              node: {
                game: { displayName: 'World of Warcraft', id: datatype.uuid() },
                id: datatype.uuid(),
              },
            },
            {
              node: {
                game: { displayName: 'Hearthstone', id: datatype.uuid() },
                id: datatype.uuid(),
              },
            },
            {
              node: {
                game: { displayName: 'Diablo 3', id: datatype.uuid() },
                id: datatype.uuid(),
              },
            },
          ],
        },
      },
    });

    expect(wrapper.find(CoreText)).toIncludeText(
      'arthas streams World of Warcraft, Hearthstone and Diablo 3.',
    );
  });

  it('uses last broadcast info to populate most recently played game', () => {
    const { wrapper } = setup({
      user: {
        displayName: 'arthas',
        lastBroadcast: { game: { displayName: 'mock game' } },
        videos: {
          edges: [
            {
              node: {
                game: { displayName: 'World of Warcraft', id: datatype.uuid() },
                id: datatype.uuid(),
              },
            },
          ],
        },
      },
    });

    expect(wrapper.find(CoreText)).toIncludeText(
      'arthas streams mock game and World of Warcraft.',
    );
  });

  it('renders a default text when no videos, no last broadcast and no description', () => {
    const { wrapper } = setup({
      user: {
        description: null,
        displayName: 'arthas',
        lastBroadcast: null,
        videos: null,
      },
    });

    expect(wrapper.find(CoreText)).toIncludeText(
      "We don't know much about them, but we're sure arthas is great.",
    );
  });
});
