import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { RemSVG } from 'tachyon-more-ui';
import { getFormattedUserDisplayName } from 'tachyon-utils';
import {
  AlignItems,
  Color,
  CoreText,
  Display,
  Layout,
  SVGAsset,
  SVGType,
  TextType,
} from 'twitch-core-ui';
import type { ChannelName_user } from './__generated__/ChannelName_user.graphql';

type ChannelNameProps = {
  user: ChannelName_user;
};

export const ChannelNameBase: FC<ChannelNameProps> = ({ user }) => {
  const displayName = getFormattedUserDisplayName(user);

  return (
    // minWidth: 0 allows element to shrink smaller than its contents (allowing text to be ellipsized). see: https://stackoverflow.com/a/36247448
    <Layout alignItems={AlignItems.Center} display={Display.Flex} minWidth={0}>
      <CoreText color={Color.Base} ellipsis type={TextType.H3}>
        {displayName}
      </CoreText>
      {user.roles?.isPartner && (
        <Layout padding={{ left: 0.5 }}>
          <RemSVG
            asset={SVGAsset.Verified}
            heightRem={1.6}
            type={SVGType.Brand}
            widthRem={1.6}
          />
        </Layout>
      )}
    </Layout>
  );
};

ChannelNameBase.displayName = 'ChannelName';

export const ChannelName = createFragmentContainer(ChannelNameBase, {
  user: graphql`
    fragment ChannelName_user on User {
      displayName
      login
      roles {
        isPartner
      }
    }
  `,
});
