import { RemSVG } from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import type { ChannelName_user } from './__generated__/ChannelName_user.graphql';
import { ChannelNameBase } from '.';

const generateUser = (
  overrides: Partial<ChannelName_user> = {},
): ChannelName_user => ({
  ' $refType': 'ChannelName_user',
  displayName: 'arthas',
  login: 'arthas',
  roles: null,
  ...overrides,
});

describe(ChannelNameBase, () => {
  const setup = createShallowWrapperFactory(ChannelNameBase, () => ({
    user: generateUser(),
  }));

  it('renders a partner icon when user is partner', () => {
    const { wrapper } = setup({
      user: generateUser({ roles: { isPartner: true } }),
    });

    expect(wrapper.find(RemSVG)).toExist();
  });
});
