import { datatype } from 'faker';
import { StreamType } from 'tachyon-more-ui';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { CoreText } from 'twitch-core-ui';
import { ChannelStatusBase } from '.';

describe(ChannelStatusBase, () => {
  const setup = createMountWrapperFactory(ChannelStatusBase, () => ({
    user: {
      ' $refType': 'ChannelStatus_user',
      hosting: null,
      lastBroadcast: null,
      stream: null,
    },
  }));

  it('renders a summary when user is online', () => {
    const { wrapper } = setup({
      user: {
        stream: {
          createdAt: '2021-02-07T00:54:10.814362Z',
          game: {
            displayName: 'World of Warcraft',
            id: datatype.uuid(),
          },
          id: datatype.uuid(),
          type: StreamType.Live,
          viewersCount: 300,
        },
      },
    });

    expect(wrapper.find(CoreText)).toIncludeText(
      'Streaming <x:strong>World of Warcraft</x:strong>',
    );
  });

  it('renders a summary when user is hosting', () => {
    const { wrapper } = setup({
      user: {
        hosting: {
          displayName: 'arthas',
          id: datatype.uuid(),
          login: 'arthas',
        },
      },
    });

    expect(wrapper.find(CoreText)).toIncludeText(
      'Hosting <x:strong>arthas</x:strong>',
    );
  });

  it('renders a rerun summary when user is running a rerun', () => {
    const { wrapper: first } = setup({
      user: {
        stream: {
          createdAt: '2021-02-03T00:54:10.814362Z',
          type: StreamType.Rerun,
        },
      },
    });

    expect(first.find(CoreText)).toIncludeText('Streaming a rerun from');

    const { wrapper: second } = setup({
      user: {
        stream: {
          createdAt: null,
          type: StreamType.Rerun,
        },
      },
    });

    expect(second.find(CoreText)).toIncludeText('Streaming a rerun');
  });

  it('renders last broadcast time when user is offline and not hosting', () => {
    const { wrapper } = setup({
      user: {
        lastBroadcast: {
          game: {
            displayName: 'World of Warcraft',
            id: datatype.uuid(),
          },
          id: datatype.uuid(),
          startedAt: '2021-02-08T00:54:10.814362Z',
        },
      },
    });

    expect(wrapper.find(CoreText)).toIncludeText('Last live');
  });
});
