import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { formatFollowers } from 'tachyon-more-ui';
import { Color, CoreText, Layout } from 'twitch-core-ui';

// istanbul ignore next: trivial
export const FollowerCount: FC<{ count: number }> = ({ count }) => {
  const intl = useIntl();

  return (
    <Layout padding={{ top: 1 }}>
      <CoreText color={Color.Alt}>{formatFollowers(intl, count)}</CoreText>
    </Layout>
  );
};

FollowerCount.displayName = 'FollowerCount';
