import type { FC } from 'react';
import styled from 'styled-components';
import { BandsInTownSvg, MixerSvg, RemSVG, VkSvg } from 'tachyon-more-ui';
import { AlignItems, Color, Display, Layout, SVGAsset } from 'twitch-core-ui';
import { DynamicThemeMap } from 'twitch-core-ui-tokens';
import { useTheme } from '../../../../../../theme';

export enum KnownSiteNames {
  Amazon = 'amazon',
  BandsInTown = 'bandsintown',
  Battlenet = 'battlenet',
  Discord = 'discord',
  DiscordApp = 'discordapp',
  Facebook = 'facebook',
  Github = 'github',
  Instagram = 'instagram',
  Mixer = 'mixer',
  Reddit = 'reddit',
  SoundCloud = 'soundcloud',
  Spotify = 'spotify',
  Steam = 'steam',
  SteamCommunity = 'steamcommunity',
  SteamPowered = 'steampowered',
  Twitch = 'twitch',
  Twitter = 'twitter',
  Vk = 'vk',
  WhatsApp = 'whatsapp',
  XboxOne = 'xbox',
  YouTube = 'youtube',
}

const ScIconWrapper = styled(Layout)<{ $currentTheme: 'dark' | 'light' }>`
  fill: ${(p) => DynamicThemeMap[p.$currentTheme]['color-text-base']};
  height: auto;
  width: 1.6rem;
`;

export const SocialIcon: FC<{ name: string }> = ({ name }) => {
  const { currentTheme } = useTheme();
  const customIcon = getCustomIcon(name);

  if (customIcon) {
    return (
      <ScIconWrapper
        $currentTheme={currentTheme}
        alignItems={AlignItems.Center}
        display={Display.Flex}
      >
        {customIcon}
      </ScIconWrapper>
    );
  }

  return (
    <Layout
      alignItems={AlignItems.Center}
      color={Color.Base}
      display={Display.Flex}
    >
      <RemSVG asset={getCoreIcon(name)} heightRem={1.6} widthRem={1.6} />
    </Layout>
  );
};

SocialIcon.displayName = 'SocialIcon';

const getCoreIcon = (name: string) => {
  switch (name) {
    case KnownSiteNames.Twitch:
      return SVGAsset.LogoGlitch;
    case KnownSiteNames.Discord:
    case KnownSiteNames.DiscordApp:
      return SVGAsset.Discord;
    case KnownSiteNames.YouTube:
      return SVGAsset.YouTube;
    case KnownSiteNames.Instagram:
      return SVGAsset.Instagram;
    case KnownSiteNames.Facebook:
      return SVGAsset.Facebook;
    case KnownSiteNames.Twitter:
      return SVGAsset.Twitter;
    case KnownSiteNames.Amazon:
      return SVGAsset.Amazon;
    case KnownSiteNames.Reddit:
      return SVGAsset.Reddit;
    case KnownSiteNames.Github:
      return SVGAsset.Github;
    case KnownSiteNames.XboxOne:
      return SVGAsset.XboxOne;
    case KnownSiteNames.WhatsApp:
      return SVGAsset.WhatsApp;
    case KnownSiteNames.Steam:
    case KnownSiteNames.SteamCommunity:
    case KnownSiteNames.SteamPowered:
      return SVGAsset.Steam;
    case KnownSiteNames.Spotify:
      return SVGAsset.Spotify;
    case KnownSiteNames.SoundCloud:
      return SVGAsset.Soundcloud;
    default:
      return SVGAsset.Link;
  }
};

const getCustomIcon = (name: string) => {
  switch (name) {
    case KnownSiteNames.BandsInTown:
      return <BandsInTownSvg />;
    case KnownSiteNames.Mixer:
      return <MixerSvg />;
    case KnownSiteNames.Vk:
      return <VkSvg />;
    default:
      return null;
  }
};
