import { BandsInTownSvg, MixerSvg, RemSVG, VkSvg } from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { SVGAsset } from 'twitch-core-ui';
import { KnownSiteNames, SocialIcon } from '.';

const coreIcons = {
  [KnownSiteNames.Twitch]: SVGAsset.LogoGlitch,
  [KnownSiteNames.Discord]: SVGAsset.Discord,
  [KnownSiteNames.DiscordApp]: SVGAsset.Discord,
  [KnownSiteNames.YouTube]: SVGAsset.YouTube,
  [KnownSiteNames.Instagram]: SVGAsset.Instagram,
  [KnownSiteNames.Facebook]: SVGAsset.Facebook,
  [KnownSiteNames.Twitter]: SVGAsset.Twitter,
  [KnownSiteNames.Amazon]: SVGAsset.Amazon,
  [KnownSiteNames.Reddit]: SVGAsset.Reddit,
  [KnownSiteNames.Github]: SVGAsset.Github,
  [KnownSiteNames.XboxOne]: SVGAsset.XboxOne,
  [KnownSiteNames.WhatsApp]: SVGAsset.WhatsApp,
  [KnownSiteNames.Steam]: SVGAsset.Steam,
  [KnownSiteNames.SteamCommunity]: SVGAsset.Steam,
  [KnownSiteNames.SteamPowered]: SVGAsset.Steam,
  [KnownSiteNames.Spotify]: SVGAsset.Spotify,
  [KnownSiteNames.SoundCloud]: SVGAsset.Soundcloud,
};

const customIcons = {
  [KnownSiteNames.BandsInTown]: BandsInTownSvg,
  [KnownSiteNames.Mixer]: MixerSvg,
  [KnownSiteNames.Vk]: VkSvg,
};

describe(SocialIcon, () => {
  const setup = createShallowWrapperFactory(SocialIcon, () => ({
    name: 'external',
  }));

  describe('core icons', () => {
    Object.entries(coreIcons).forEach(([name, Component]) => {
      it(`renders icon for ${name}`, () => {
        const { wrapper } = setup({ name });

        expect(wrapper.find(RemSVG).prop('asset')).toBe(Component);
      });
    });
  });

  describe('custom icons', () => {
    Object.entries(customIcons).forEach(([name, Component]) => {
      it(`renders icon for ${name}`, () => {
        const { wrapper } = setup({ name });
        expect(wrapper.find(Component)).toExist();
      });
    });
  });

  it('renders an icon as default case', () => {
    const { wrapper } = setup({ name: 'unknown-icon' });

    expect(wrapper.find(RemSVG).prop('asset')).toBe(SVGAsset.Link);
  });
});
