import { datatype } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreLink } from 'twitch-core-ui';
import { SocialMediaLinksBase } from '.';

describe(SocialMediaLinksBase, () => {
  const setup = createShallowWrapperFactory(SocialMediaLinksBase, () => ({
    expanded: false,
    user: {
      ' $refType': 'SocialMediaLinks_user',
      channel: {
        id: datatype.uuid(),
        socialMedias: [
          {
            id: datatype.uuid(),
            name: 'twitter',
            title: 'twitter',
            url: 'https://twitter.com/foo',
          },
          {
            id: datatype.uuid(),
            name: 'instagram',
            title: 'instagram',
            url: 'https://instagram.com/foo',
          },
          {
            id: datatype.uuid(),
            name: 'spotify',
            title: 'spotify',
            url: 'https://spotify.com/foo',
          },
        ],
      },
    },
  }));

  it('renders empty when there is no link', () => {
    const { wrapper } = setup({ user: { channel: { socialMedias: null } } });

    expect(wrapper).toBeEmptyRender();
  });

  it('renders 1 item max when not expanded', () => {
    const { wrapper } = setup({ expanded: false });

    expect(wrapper.find(CoreLink)).toHaveLength(1);
  });

  it('renders 5 items max when expanded', () => {
    const { wrapper: first } = setup({ expanded: true });
    expect(first.find(CoreLink)).toHaveLength(3);

    const { wrapper: second } = setup({
      expanded: true,
      user: {
        channel: {
          socialMedias: [
            {
              id: datatype.uuid(),
              name: 'twitter',
              title: 'twitter',
              url: 'https://twitter.com/foo',
            },
            {
              id: datatype.uuid(),
              name: 'instagram',
              title: 'instagram',
              url: 'https://instagram.com/foo',
            },
            {
              id: datatype.uuid(),
              name: 'spotify',
              title: 'spotify',
              url: 'https://spotify.com/foo',
            },
            {
              id: datatype.uuid(),
              name: 'github',
              title: 'github',
              url: 'https://github.com/foo',
            },
            {
              id: datatype.uuid(),
              name: 'soundcloud',
              title: 'soundcloud',
              url: 'https://soundcloud.com/foo',
            },
            {
              id: datatype.uuid(),
              name: 'mixer',
              title: 'mixer',
              url: 'https://mixer.com/foo',
            },
          ],
        },
      },
    });

    expect(second.find(CoreLink)).toHaveLength(5);
  });
});
