import { image } from 'faker';
import { isAndroidOS, isIOS } from 'tachyon-environment';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { FollowButtonUpsell } from '../../../common';
import { ChannelProfileInfoBase } from '.';

jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  isAndroidOS: jest.fn(),
  isIOS: jest.fn(),
}));

const isAndroidOSSpy = isAndroidOS as jest.Mock;
const isIOSSpy = isIOS as jest.Mock;

describe(ChannelProfileInfoBase, () => {
  const setup = createShallowWrapperFactory(ChannelProfileInfoBase, () => ({
    user: {
      ' $fragmentRefs': {
        ChannelDescription_user: true,
        ChannelName_user: true,
        ChannelStatus_user: true,
        SocialMediaLinks_user: true,
      },
      ' $refType': 'ChannelProfileInfo_user',
      displayName: 'foo',
      followers: {
        totalCount: 300,
      },
      login: 'foo',
      primaryColorHex: null,
      profileImageURL: image.imageUrl(),
      roles: {
        isPartner: true,
      },
      stream: null,
    },
  }));

  it('renders follow button if device is ios', () => {
    isIOSSpy.mockImplementationOnce(() => true);
    const { wrapper } = setup();
    expect(wrapper.find(FollowButtonUpsell)).toExist();
  });

  it('renders follow button if device is android', () => {
    isAndroidOSSpy.mockImplementationOnce(() => true);
    const { wrapper } = setup();
    expect(wrapper.find(FollowButtonUpsell)).toExist();
  });

  it("doesn't render follow button if device isn't android or ios", () => {
    isIOSSpy.mockImplementationOnce(() => false);
    isAndroidOSSpy.mockImplementationOnce(() => false);
    const { wrapper } = setup();
    expect(wrapper.find(FollowButtonUpsell)).not.toExist();
  });
});
