import { datatype, lorem } from 'faker';
import { useLazyLoadQuery } from 'react-relay/hooks';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { NotFoundErrorLayout } from '../NotFoundErrorLayout';
import { ChannelLayout } from '.';

jest.mock('react-relay/hooks', () => ({
  useLazyLoadQuery: jest.fn(() => ({ user: null })),
}));

const mockUseLazyLoadQuery = useLazyLoadQuery as jest.Mock;

describe(ChannelLayout, () => {
  const user = {
    id: datatype.uuid(),
    login: lorem.word().toLowerCase(),
  };

  const setup = createShallowWrapperFactory(ChannelLayout, () => ({
    loading: false,
    login: lorem.word().toLowerCase(),
    user: {
      ' $data': {
        ' $fragmentRefs': {
          ChannelCover_user: true,
          ChannelProfileInfo_user: true,
        },
        ' $refType': 'ChannelLayout_user',
        ...user,
      },
      ' $fragmentRefs': { ChannelLayout_user: true },
    },
  }));

  it('renders a not found error for an invalid channel', () => {
    mockUseLazyLoadQuery.mockImplementationOnce(() => ({ user: null }));
    const { wrapper } = setup();
    expect(wrapper.find(NotFoundErrorLayout)).toExist();
  });

  it('renders', () => {
    mockUseLazyLoadQuery.mockImplementationOnce(() => ({ user }));
    const { wrapper } = setup();
    expect(wrapper.find(NotFoundErrorLayout)).not.toExist();
  });
});
