import type { FC } from 'react';
import styled from 'styled-components';
import { useIntl } from 'tachyon-intl';
import {
  AlignItems,
  Color,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  JustifyContent,
  Layout,
  TextAlign,
} from 'twitch-core-ui';
import { Page } from '../Page';

// istanbul ignore next: trivial
const ScImage = styled.img`
  max-height: 100%;
`;

// istanbul ignore next: trivial
const ScImageContainer = styled.div`
  align-items: flex-end;
  display: flex;
  flex-shrink: 1;
  justify-content: flex-start;
  min-height: 0;
`;

// istanbul ignore next: trivial
const ScLayout = styled(Layout)`
  @media (min-height: 600px) {
    flex-direction: column !important;
    justify-content: around !important;
  }
`;

/**
 * A full-screen page (including TopNav) for showing a 5XX error UI
 */
// istanbul ignore next: trivial
export const InternalErrorLayout: FC = () => {
  const { formatMessage } = useIntl();

  return (
    <Page>
      <ScLayout
        breakpointExtraSmall={{
          flexDirection: FlexDirection.RowReverse,
          justifyContent: JustifyContent.End,
        }}
        breakpointMedium={{
          flexDirection: FlexDirection.Column,
          justifyContent: JustifyContent.Around,
        }}
        display={Display.Flex}
        flexDirection={FlexDirection.Column}
        fullHeight
        justifyContent={JustifyContent.Around}
      >
        <Layout
          alignItems={AlignItems.Center}
          display={Display.Flex}
          flexGrow={1}
          justifyContent={JustifyContent.Center}
          padding={{ x: 2 }}
          textAlign={TextAlign.Center}
        >
          <CoreText
            breakpointSmall={{ fontSize: FontSize.Size2 }}
            color={Color.Alt2}
            fontSize={FontSize.Size3}
          >
            {formatMessage(
              'Looks like something went wrong, please try again at another time.',
              'page-error-boundary',
            )}
          </CoreText>
        </Layout>
        <ScImageContainer>
          <ScImage
            src="/static/images/error-500.png"
            srcSet="/static/images/error-500.png 1x, /static/images/error-500@2x.png 2x"
          />
        </ScImageContainer>
      </ScLayout>
    </Page>
  );
};

InternalErrorLayout.displayName = 'InternalErrorLayout';
