import { InteractionType } from 'tachyon-event-tracker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import { mockRouter } from '../../../../routing/test-mocks';
import { OnlineMessageCard, RELOAD_INTERACTION_VALUE } from '.';

const mockTrackInteraction = jest.fn();
jest.mock('tachyon-event-tracker', () => ({
  ...jest.requireActual('tachyon-event-tracker'),
  useInteractionTracking: () => mockTrackInteraction,
}));

jest.mock('../../../../routing', () => ({
  ...jest.requireActual('../../../../routing'),
  useTachyonRouter: () => mockRouter,
}));

describe(OnlineMessageCard, () => {
  const setup = createShallowWrapperFactory(OnlineMessageCard, () => ({
    show: true,
  }));

  it('calls window.location.reload when cta button is clicked', () => {
    const { wrapper } = setup();
    wrapper.find(Button).simulate('click');

    expect(mockTrackInteraction).toHaveBeenCalledWith({
      interaction: InteractionType.Click,
      interactionContent: RELOAD_INTERACTION_VALUE,
    });

    expect(mockRouter.reload).toHaveBeenCalled();
  });
});
