import { createMountWrapperFactory } from 'tachyon-test-utils';
import { LoadingSpinner } from 'twitch-core-ui';
import { TOP_NAV_HEIGHT_PX } from '../../../config';
import { TopNav } from '../../common';
import { Page } from '.';

jest.mock('../../common', () => ({
  TopNav: jest.fn(() => null),
}));

describe(Page, () => {
  const setup = createMountWrapperFactory(Page);

  it('hides the top nav when hidden is specified', () => {
    const { wrapper } = setup({ hideTopNav: true });
    expect(wrapper.find(TopNav)).not.toExist();
    expect(wrapper.find('main')).toHaveStyleRule('margin-top', '0px');
    expect(wrapper.find('main')).toHaveStyleRule('height', '100%');
  });

  it('renders the top nav and accounts for it with style rules', () => {
    const { wrapper } = setup();
    expect(wrapper.find(TopNav)).toExist();
    expect(wrapper.find('main')).toHaveStyleRule(
      'margin-top',
      `${TOP_NAV_HEIGHT_PX}px`,
    );
    expect(wrapper.find('main')).toHaveStyleRule(
      'height',
      `calc(100% - ${TOP_NAV_HEIGHT_PX}px)`,
    );
  });

  it('renders a loading spinner when loading', () => {
    const { wrapper } = setup({ loading: true });
    expect(wrapper.find(LoadingSpinner)).toExist();
  });

  it('renders children when not loading', () => {
    const { wrapper } = setup();
    expect(wrapper.find(LoadingSpinner)).not.toExist();
  });
});
