import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ButtonIcon, SVGAsset } from 'twitch-core-ui';
import { ChannelPlayerLayout } from '.';

describe(ChannelPlayerLayout, () => {
  const setup = createShallowWrapperFactory(ChannelPlayerLayout, () => ({
    player: 'player',
  }));

  it('shows collapse button when right column is shown and expand button when right column is closed', () => {
    const { wrapper } = setup();
    const button = wrapper.find(ButtonIcon);

    expect(button.prop('icon')).toEqual(SVGAsset.ColSlideRight);
    button.simulate('click');
    expect(wrapper.find(ButtonIcon).first().prop('icon')).toEqual(
      SVGAsset.ColSlideLeft,
    );
  });
});
