import { validId } from 'tachyon-relay';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import type { OmitRefType } from 'tachyon-type-library';
import { StreamTagList } from '../../../common';
import type { StreamInfoBox_channelBase } from './__generated__/StreamInfoBox_channelBase.graphql';
import { StreamInfoBoxBase } from '.';

describe(StreamInfoBoxBase, () => {
  const mockChannel = (): OmitRefType<StreamInfoBox_channelBase> => ({
    displayName: 'hola',
    id: validId(),
    login: 'hola',
    profileImageURL: 'image',
    stream: {
      ' $fragmentRefs': { TagList_stream: true },
      game: { name: 'Fortnite' },
      id: validId(),
    },
  });

  const setup = createShallowWrapperFactory(StreamInfoBoxBase, () => ({
    channel: {
      ' $refType': 'StreamInfoBox_channel',
      ...mockChannel(),
      hosting: null,
    },
  }));

  it('does not render StreamTagList without a stream', () => {
    const { wrapper } = setup({ channel: { stream: null } });
    expect(wrapper.find(StreamTagList)).not.toExist();
  });

  it('renders StreamTagList when a stream is valid', () => {
    const { wrapper } = setup();
    expect(wrapper.find(StreamTagList)).toExist();
  });
});
