/* tslint:disable */
/* eslint-disable */
// @ts-nocheck

import { ConcreteRequest } from "relay-runtime";
import { FragmentRefs } from "relay-runtime";
export type Channel_QueryVariables = {
    login: string;
    isBrowser: boolean;
    url: string;
};
export type Channel_QueryResponse = {
    readonly channel: {
        readonly id: string;
        readonly login: string;
        readonly displayName: string;
        readonly description: string | null;
        readonly broadcastSettings: {
            readonly id: string;
            readonly title: string;
            readonly game: {
                readonly displayName: string;
            } | null;
        } | null;
        readonly stream: {
            readonly id: string;
            readonly createdAt: string | null;
            readonly height: number | null;
            readonly previewImageURL: string | null;
            readonly game: {
                readonly id: string;
                readonly name: string;
            } | null;
        } | null;
        readonly hosting: {
            readonly id: string;
            readonly login: string;
            readonly stream: {
                readonly id: string;
                readonly game: {
                    readonly id: string;
                    readonly name: string;
                } | null;
            } | null;
        } | null;
        readonly " $fragmentRefs": FragmentRefs<"StreamPlayer_channel" | "StreamInfoBox_channel">;
    } | null;
    readonly channelHome?: {
        readonly id: string;
        readonly login: string;
        readonly displayName: string;
        readonly stream: {
            readonly id: string;
            readonly " $fragmentRefs": FragmentRefs<"FeaturedSection_stream">;
        } | null;
        readonly hosting: {
            readonly stream: {
                readonly " $fragmentRefs": FragmentRefs<"FeaturedSection_hosting">;
            } | null;
        } | null;
        readonly archives: {
            readonly edges: ReadonlyArray<{
                readonly node: {
                    readonly " $fragmentRefs": FragmentRefs<"FeaturedSection_archives">;
                } | null;
            } | null> | null;
        } | null;
        readonly videoShelves: {
            readonly edges: ReadonlyArray<{
                readonly node: {
                    readonly title: string;
                    readonly items: ReadonlyArray<{
                        readonly " $fragmentRefs": FragmentRefs<"VideoShelf_items">;
                    }> | null;
                } | null;
            }> | null;
        } | null;
        readonly channel: {
            readonly home: {
                readonly shelves: {
                    readonly categoryShelf: {
                        readonly edges: ReadonlyArray<{
                            readonly node: {
                                readonly " $fragmentRefs": FragmentRefs<"CategoryShelf_items">;
                            } | null;
                        }>;
                    } | null;
                    readonly streamerShelf: {
                        readonly edges: ReadonlyArray<{
                            readonly node: {
                                readonly " $fragmentRefs": FragmentRefs<"StreamerShelf_items">;
                            } | null;
                        }>;
                    } | null;
                } | null;
            } | null;
        } | null;
        readonly " $fragmentRefs": FragmentRefs<"ChannelLayout_user">;
    } | null;
    readonly " $fragmentRefs": FragmentRefs<"PageHead_query">;
};
export type Channel_Query = {
    readonly response: Channel_QueryResponse;
    readonly variables: Channel_QueryVariables;
};



/*
query Channel_Query(
  $login: String!
  $isBrowser: Boolean!
  $url: String!
) {
  channel: user(login: $login) {
    ...StreamPlayer_channel
    ...StreamInfoBox_channel
    id
    login
    displayName
    description
    broadcastSettings {
      id
      title
      game {
        displayName
        id
      }
    }
    stream {
      id
      createdAt
      height
      previewImageURL
      game {
        id
        name
      }
    }
    hosting {
      id
      login
      stream {
        id
        game {
          id
          name
        }
      }
    }
  }
  channelHome: user(login: $login) @skip(if: $isBrowser) {
    ...ChannelLayout_user
    id
    login
    displayName
    stream {
      id
      ...FeaturedSection_stream
    }
    hosting {
      stream {
        ...FeaturedSection_hosting
        id
      }
      id
    }
    archives: videos(first: 1, type: ARCHIVE, sort: TIME) {
      edges {
        node {
          ...FeaturedSection_archives
          id
        }
      }
    }
    videoShelves(first: 1) {
      edges {
        node {
          title
          items {
            __typename
            ...VideoShelf_items
          }
          id
        }
      }
    }
    channel {
      home {
        shelves {
          categoryShelf {
            edges {
              node {
                ...CategoryShelf_items
                id
              }
            }
          }
          streamerShelf {
            edges {
              node {
                ...StreamerShelf_items
                id
              }
            }
          }
        }
      }
      id
    }
  }
  ...PageHead_query
}

fragment CategoryShelf_items on Game {
  id
  name
  ...GameCard_game
}

fragment ChannelCover_user on User {
  login
  bannerImageURL
  primaryColorHex
}

fragment ChannelDescription_user on User {
  login
  displayName
  description
  lastBroadcast {
    game {
      displayName
      id
    }
    id
  }
  videos(first: 30) {
    edges {
      node {
        id
        game {
          id
          displayName
        }
      }
    }
  }
}

fragment ChannelFeaturedCardStream_stream on Stream {
  id
  broadcaster {
    broadcastSettings {
      title
      id
    }
    id
    login
  }
  previewImageURL
  game {
    displayName
    id
  }
}

fragment ChannelFeaturedCardVideo_video on Video {
  id
  title
  viewCount
  previewThumbnailURL
  publishedAt
  game {
    name
    id
  }
}

fragment ChannelLayout_user on User {
  ...ChannelCover_user
  ...ChannelProfileInfo_user
  id
  login
}

fragment ChannelName_user on User {
  displayName
  login
  roles {
    isPartner
  }
}

fragment ChannelProfileInfo_user on User {
  ...ChannelStatus_user
  ...ChannelDescription_user
  ...ChannelName_user
  ...SocialMediaLinks_user
  profileImageURL(width: 150)
  login
  displayName
  primaryColorHex
  followers {
    totalCount
  }
  stream {
    id
  }
}

fragment ChannelStatus_user on User {
  hosting {
    id
    login
    displayName
  }
  lastBroadcast {
    id
    startedAt
    game {
      id
      displayName
    }
  }
  stream {
    id
    createdAt
    game {
      id
      displayName
    }
    type
    viewersCount
  }
}

fragment FeaturedSection_archives on Video {
  ...ChannelFeaturedCardVideo_video
}

fragment FeaturedSection_hosting on Stream {
  ...ChannelFeaturedCardStream_stream
}

fragment FeaturedSection_stream on Stream {
  ...ChannelFeaturedCardStream_stream
}

fragment GameCard_game on Game {
  name
  id
  displayName
  viewersCount
  boxArtURL
}

fragment PageHead_query on Query {
  urlMetadata(url: $url) {
    title
    metatags {
      name
      attributes {
        key
        value
      }
    }
    jsonld
    share {
      title
      text
      url
    }
  }
}

fragment SocialMediaLinks_user on User {
  channel {
    id
    socialMedias {
      id
      name
      title
      url
    }
  }
}

fragment StreamInfoBox_channel on User {
  id
  login
  displayName
  profileImageURL(width: 50)
  stream {
    id
    game {
      name
      id
    }
    ...TagList_stream
  }
  hosting {
    id
    login
    displayName
    profileImageURL(width: 50)
    stream {
      id
      game {
        name
        id
      }
      ...TagList_stream
    }
  }
}

fragment StreamPlayer_channel on User {
  id
  displayName
  login
  offlineImageURL
  roles {
    isPartner
  }
  self {
    subscriptionBenefit {
      id
    }
  }
  stream {
    id
    game {
      id
      name
    }
    previewImageURL
    restrictionType
    self {
      canWatch
    }
    archiveVideo {
      id
    }
  }
  broadcastSettings {
    isMature
    id
  }
  videos(sort: TIME, first: 3) {
    edges {
      node {
        id
        previewThumbnailURL
        title
        status
      }
    }
  }
  hosting {
    id
    displayName
    login
    offlineImageURL
    roles {
      isPartner
    }
    self {
      subscriptionBenefit {
        id
      }
    }
    stream {
      id
      game {
        id
        name
      }
      previewImageURL
      restrictionType
      self {
        canWatch
      }
      archiveVideo {
        id
      }
    }
    broadcastSettings {
      isMature
      id
    }
    videos(sort: TIME, first: 3) {
      edges {
        node {
          id
          previewThumbnailURL
          title
          status
        }
      }
    }
  }
}

fragment StreamerShelf_items on User {
  id
  ...UserCard_user
}

fragment TagLink_tag on Tag {
  id
  tagName
  localizedDescription
  localizedName
}

fragment TagList_stream on Stream {
  streamTags: tags {
    ...TagLink_tag
    id
  }
}

fragment UserCard_user on User {
  id
  displayName
  login
  stream {
    viewersCount
    id
  }
  primaryColorHex
  profileImageURL(width: 150)
}

fragment VideoShelfClip_clip on Clip {
  id
  broadcaster {
    login
    id
  }
  clipCreatedAt: createdAt
  durationSeconds
  game {
    name
    displayName
    id
  }
  slug
  thumbnailURL
  clipTitle: title
  clipViewCount: viewCount
}

fragment VideoShelfVideo_video on Video {
  id
  createdAt
  lengthSeconds
  game {
    name
    displayName
    id
  }
  previewThumbnailURL
  title
  viewCount
}

fragment VideoShelf_items on VideoShelfItem {
  __isVideoShelfItem: __typename
  __typename
  ... on Clip {
    id
    game {
      name
      id
    }
    ...VideoShelfClip_clip
  }
  ... on Video {
    id
    game {
      name
      id
    }
    ...VideoShelfVideo_video
  }
}
*/

const node: ConcreteRequest = (function(){
var v0 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "isBrowser"
},
v1 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "login"
},
v2 = {
  "defaultValue": null,
  "kind": "LocalArgument",
  "name": "url"
},
v3 = [
  {
    "kind": "Variable",
    "name": "login",
    "variableName": "login"
  }
],
v4 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "id",
  "storageKey": null
},
v5 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "login",
  "storageKey": null
},
v6 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "displayName",
  "storageKey": null
},
v7 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "description",
  "storageKey": null
},
v8 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "title",
  "storageKey": null
},
v9 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "createdAt",
  "storageKey": null
},
v10 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "height",
  "storageKey": null
},
v11 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "previewImageURL",
  "storageKey": null
},
v12 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "name",
  "storageKey": null
},
v13 = {
  "alias": null,
  "args": null,
  "concreteType": "Game",
  "kind": "LinkedField",
  "name": "game",
  "plural": false,
  "selections": [
    (v4/*: any*/),
    (v12/*: any*/)
  ],
  "storageKey": null
},
v14 = {
  "kind": "Literal",
  "name": "first",
  "value": 1
},
v15 = {
  "kind": "Literal",
  "name": "sort",
  "value": "TIME"
},
v16 = [
  (v14/*: any*/),
  (v15/*: any*/),
  {
    "kind": "Literal",
    "name": "type",
    "value": "ARCHIVE"
  }
],
v17 = [
  (v14/*: any*/)
],
v18 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "offlineImageURL",
  "storageKey": null
},
v19 = {
  "alias": null,
  "args": null,
  "concreteType": "UserRoles",
  "kind": "LinkedField",
  "name": "roles",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "isPartner",
      "storageKey": null
    }
  ],
  "storageKey": null
},
v20 = [
  (v4/*: any*/)
],
v21 = {
  "alias": null,
  "args": null,
  "concreteType": "UserSelfConnection",
  "kind": "LinkedField",
  "name": "self",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "concreteType": "SubscriptionBenefit",
      "kind": "LinkedField",
      "name": "subscriptionBenefit",
      "plural": false,
      "selections": (v20/*: any*/),
      "storageKey": null
    }
  ],
  "storageKey": null
},
v22 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "restrictionType",
  "storageKey": null
},
v23 = {
  "alias": null,
  "args": null,
  "concreteType": "StreamSelfConnection",
  "kind": "LinkedField",
  "name": "self",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "canWatch",
      "storageKey": null
    }
  ],
  "storageKey": null
},
v24 = {
  "alias": null,
  "args": null,
  "concreteType": "Video",
  "kind": "LinkedField",
  "name": "archiveVideo",
  "plural": false,
  "selections": (v20/*: any*/),
  "storageKey": null
},
v25 = {
  "alias": "streamTags",
  "args": null,
  "concreteType": "Tag",
  "kind": "LinkedField",
  "name": "tags",
  "plural": true,
  "selections": [
    (v4/*: any*/),
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "tagName",
      "storageKey": null
    },
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "localizedDescription",
      "storageKey": null
    },
    {
      "alias": null,
      "args": null,
      "kind": "ScalarField",
      "name": "localizedName",
      "storageKey": null
    }
  ],
  "storageKey": null
},
v26 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "isMature",
  "storageKey": null
},
v27 = {
  "alias": null,
  "args": null,
  "concreteType": "Game",
  "kind": "LinkedField",
  "name": "game",
  "plural": false,
  "selections": [
    (v6/*: any*/),
    (v4/*: any*/)
  ],
  "storageKey": null
},
v28 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "previewThumbnailURL",
  "storageKey": null
},
v29 = {
  "alias": null,
  "args": [
    {
      "kind": "Literal",
      "name": "first",
      "value": 3
    },
    (v15/*: any*/)
  ],
  "concreteType": "VideoConnection",
  "kind": "LinkedField",
  "name": "videos",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "concreteType": "VideoEdge",
      "kind": "LinkedField",
      "name": "edges",
      "plural": true,
      "selections": [
        {
          "alias": null,
          "args": null,
          "concreteType": "Video",
          "kind": "LinkedField",
          "name": "node",
          "plural": false,
          "selections": [
            (v4/*: any*/),
            (v28/*: any*/),
            (v8/*: any*/),
            {
              "alias": null,
              "args": null,
              "kind": "ScalarField",
              "name": "status",
              "storageKey": null
            }
          ],
          "storageKey": null
        }
      ],
      "storageKey": null
    }
  ],
  "storageKey": "videos(first:3,sort:\"TIME\")"
},
v30 = {
  "alias": null,
  "args": [
    {
      "kind": "Literal",
      "name": "width",
      "value": 50
    }
  ],
  "kind": "ScalarField",
  "name": "profileImageURL",
  "storageKey": "profileImageURL(width:50)"
},
v31 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "url",
  "storageKey": null
},
v32 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "primaryColorHex",
  "storageKey": null
},
v33 = {
  "alias": null,
  "args": null,
  "concreteType": "User",
  "kind": "LinkedField",
  "name": "broadcaster",
  "plural": false,
  "selections": [
    {
      "alias": null,
      "args": null,
      "concreteType": "BroadcastSettings",
      "kind": "LinkedField",
      "name": "broadcastSettings",
      "plural": false,
      "selections": [
        (v8/*: any*/),
        (v4/*: any*/)
      ],
      "storageKey": null
    },
    (v4/*: any*/),
    (v5/*: any*/)
  ],
  "storageKey": null
},
v34 = {
  "alias": null,
  "args": null,
  "concreteType": "Game",
  "kind": "LinkedField",
  "name": "game",
  "plural": false,
  "selections": [
    (v4/*: any*/),
    (v6/*: any*/)
  ],
  "storageKey": null
},
v35 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "viewersCount",
  "storageKey": null
},
v36 = {
  "alias": null,
  "args": [
    {
      "kind": "Literal",
      "name": "width",
      "value": 150
    }
  ],
  "kind": "ScalarField",
  "name": "profileImageURL",
  "storageKey": "profileImageURL(width:150)"
},
v37 = {
  "alias": null,
  "args": null,
  "kind": "ScalarField",
  "name": "viewCount",
  "storageKey": null
},
v38 = {
  "alias": null,
  "args": null,
  "concreteType": "Game",
  "kind": "LinkedField",
  "name": "game",
  "plural": false,
  "selections": [
    (v12/*: any*/),
    (v4/*: any*/),
    (v6/*: any*/)
  ],
  "storageKey": null
};
return {
  "fragment": {
    "argumentDefinitions": [
      (v0/*: any*/),
      (v1/*: any*/),
      (v2/*: any*/)
    ],
    "kind": "Fragment",
    "metadata": null,
    "name": "Channel_Query",
    "selections": [
      {
        "alias": "channel",
        "args": (v3/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          (v4/*: any*/),
          (v5/*: any*/),
          (v6/*: any*/),
          (v7/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "BroadcastSettings",
            "kind": "LinkedField",
            "name": "broadcastSettings",
            "plural": false,
            "selections": [
              (v4/*: any*/),
              (v8/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "Game",
                "kind": "LinkedField",
                "name": "game",
                "plural": false,
                "selections": [
                  (v6/*: any*/)
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "Stream",
            "kind": "LinkedField",
            "name": "stream",
            "plural": false,
            "selections": [
              (v4/*: any*/),
              (v9/*: any*/),
              (v10/*: any*/),
              (v11/*: any*/),
              (v13/*: any*/)
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "User",
            "kind": "LinkedField",
            "name": "hosting",
            "plural": false,
            "selections": [
              (v4/*: any*/),
              (v5/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "Stream",
                "kind": "LinkedField",
                "name": "stream",
                "plural": false,
                "selections": [
                  (v4/*: any*/),
                  (v13/*: any*/)
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "StreamPlayer_channel"
          },
          {
            "args": null,
            "kind": "FragmentSpread",
            "name": "StreamInfoBox_channel"
          }
        ],
        "storageKey": null
      },
      {
        "condition": "isBrowser",
        "kind": "Condition",
        "passingValue": false,
        "selections": [
          {
            "alias": "channelHome",
            "args": (v3/*: any*/),
            "concreteType": "User",
            "kind": "LinkedField",
            "name": "user",
            "plural": false,
            "selections": [
              (v4/*: any*/),
              (v5/*: any*/),
              (v6/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "Stream",
                "kind": "LinkedField",
                "name": "stream",
                "plural": false,
                "selections": [
                  (v4/*: any*/),
                  {
                    "args": null,
                    "kind": "FragmentSpread",
                    "name": "FeaturedSection_stream"
                  }
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "User",
                "kind": "LinkedField",
                "name": "hosting",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "Stream",
                    "kind": "LinkedField",
                    "name": "stream",
                    "plural": false,
                    "selections": [
                      {
                        "args": null,
                        "kind": "FragmentSpread",
                        "name": "FeaturedSection_hosting"
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              {
                "alias": "archives",
                "args": (v16/*: any*/),
                "concreteType": "VideoConnection",
                "kind": "LinkedField",
                "name": "videos",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "VideoEdge",
                    "kind": "LinkedField",
                    "name": "edges",
                    "plural": true,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "Video",
                        "kind": "LinkedField",
                        "name": "node",
                        "plural": false,
                        "selections": [
                          {
                            "args": null,
                            "kind": "FragmentSpread",
                            "name": "FeaturedSection_archives"
                          }
                        ],
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": "videos(first:1,sort:\"TIME\",type:\"ARCHIVE\")"
              },
              {
                "alias": null,
                "args": (v17/*: any*/),
                "concreteType": "VideoShelfConnection",
                "kind": "LinkedField",
                "name": "videoShelves",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "VideoShelfEdge",
                    "kind": "LinkedField",
                    "name": "edges",
                    "plural": true,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "VideoShelf",
                        "kind": "LinkedField",
                        "name": "node",
                        "plural": false,
                        "selections": [
                          (v8/*: any*/),
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": null,
                            "kind": "LinkedField",
                            "name": "items",
                            "plural": true,
                            "selections": [
                              {
                                "args": null,
                                "kind": "FragmentSpread",
                                "name": "VideoShelf_items"
                              }
                            ],
                            "storageKey": null
                          }
                        ],
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": "videoShelves(first:1)"
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "Channel",
                "kind": "LinkedField",
                "name": "channel",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "ChannelHome",
                    "kind": "LinkedField",
                    "name": "home",
                    "plural": false,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "ChannelHomeShelves",
                        "kind": "LinkedField",
                        "name": "shelves",
                        "plural": false,
                        "selections": [
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": "ChannelHomeCategoryShelf",
                            "kind": "LinkedField",
                            "name": "categoryShelf",
                            "plural": false,
                            "selections": [
                              {
                                "alias": null,
                                "args": null,
                                "concreteType": "ChannelHomeCategoryShelfEdge",
                                "kind": "LinkedField",
                                "name": "edges",
                                "plural": true,
                                "selections": [
                                  {
                                    "alias": null,
                                    "args": null,
                                    "concreteType": "Game",
                                    "kind": "LinkedField",
                                    "name": "node",
                                    "plural": false,
                                    "selections": [
                                      {
                                        "args": null,
                                        "kind": "FragmentSpread",
                                        "name": "CategoryShelf_items"
                                      }
                                    ],
                                    "storageKey": null
                                  }
                                ],
                                "storageKey": null
                              }
                            ],
                            "storageKey": null
                          },
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": "ChannelHomeStreamerShelf",
                            "kind": "LinkedField",
                            "name": "streamerShelf",
                            "plural": false,
                            "selections": [
                              {
                                "alias": null,
                                "args": null,
                                "concreteType": "ChannelHomeStreamerShelfEdge",
                                "kind": "LinkedField",
                                "name": "edges",
                                "plural": true,
                                "selections": [
                                  {
                                    "alias": null,
                                    "args": null,
                                    "concreteType": "User",
                                    "kind": "LinkedField",
                                    "name": "node",
                                    "plural": false,
                                    "selections": [
                                      {
                                        "args": null,
                                        "kind": "FragmentSpread",
                                        "name": "StreamerShelf_items"
                                      }
                                    ],
                                    "storageKey": null
                                  }
                                ],
                                "storageKey": null
                              }
                            ],
                            "storageKey": null
                          }
                        ],
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              {
                "args": null,
                "kind": "FragmentSpread",
                "name": "ChannelLayout_user"
              }
            ],
            "storageKey": null
          }
        ]
      },
      {
        "args": null,
        "kind": "FragmentSpread",
        "name": "PageHead_query"
      }
    ],
    "type": "Query",
    "abstractKey": null
  },
  "kind": "Request",
  "operation": {
    "argumentDefinitions": [
      (v1/*: any*/),
      (v0/*: any*/),
      (v2/*: any*/)
    ],
    "kind": "Operation",
    "name": "Channel_Query",
    "selections": [
      {
        "alias": "channel",
        "args": (v3/*: any*/),
        "concreteType": "User",
        "kind": "LinkedField",
        "name": "user",
        "plural": false,
        "selections": [
          (v4/*: any*/),
          (v6/*: any*/),
          (v5/*: any*/),
          (v18/*: any*/),
          (v19/*: any*/),
          (v21/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "Stream",
            "kind": "LinkedField",
            "name": "stream",
            "plural": false,
            "selections": [
              (v4/*: any*/),
              (v13/*: any*/),
              (v11/*: any*/),
              (v22/*: any*/),
              (v23/*: any*/),
              (v24/*: any*/),
              (v25/*: any*/),
              (v9/*: any*/),
              (v10/*: any*/)
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "BroadcastSettings",
            "kind": "LinkedField",
            "name": "broadcastSettings",
            "plural": false,
            "selections": [
              (v26/*: any*/),
              (v4/*: any*/),
              (v8/*: any*/),
              (v27/*: any*/)
            ],
            "storageKey": null
          },
          (v29/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "User",
            "kind": "LinkedField",
            "name": "hosting",
            "plural": false,
            "selections": [
              (v4/*: any*/),
              (v6/*: any*/),
              (v5/*: any*/),
              (v18/*: any*/),
              (v19/*: any*/),
              (v21/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "Stream",
                "kind": "LinkedField",
                "name": "stream",
                "plural": false,
                "selections": [
                  (v4/*: any*/),
                  (v13/*: any*/),
                  (v11/*: any*/),
                  (v22/*: any*/),
                  (v23/*: any*/),
                  (v24/*: any*/),
                  (v25/*: any*/)
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "BroadcastSettings",
                "kind": "LinkedField",
                "name": "broadcastSettings",
                "plural": false,
                "selections": [
                  (v26/*: any*/),
                  (v4/*: any*/)
                ],
                "storageKey": null
              },
              (v29/*: any*/),
              (v30/*: any*/)
            ],
            "storageKey": null
          },
          (v30/*: any*/),
          (v7/*: any*/)
        ],
        "storageKey": null
      },
      {
        "alias": null,
        "args": [
          {
            "kind": "Variable",
            "name": "url",
            "variableName": "url"
          }
        ],
        "concreteType": "URLMetadata",
        "kind": "LinkedField",
        "name": "urlMetadata",
        "plural": false,
        "selections": [
          (v8/*: any*/),
          {
            "alias": null,
            "args": null,
            "concreteType": "SEOMetatag",
            "kind": "LinkedField",
            "name": "metatags",
            "plural": true,
            "selections": [
              (v12/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "SEOMetatagAttribute",
                "kind": "LinkedField",
                "name": "attributes",
                "plural": true,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "key",
                    "storageKey": null
                  },
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "value",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              }
            ],
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "kind": "ScalarField",
            "name": "jsonld",
            "storageKey": null
          },
          {
            "alias": null,
            "args": null,
            "concreteType": "URLMetadataShare",
            "kind": "LinkedField",
            "name": "share",
            "plural": false,
            "selections": [
              (v8/*: any*/),
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "text",
                "storageKey": null
              },
              (v31/*: any*/)
            ],
            "storageKey": null
          }
        ],
        "storageKey": null
      },
      {
        "condition": "isBrowser",
        "kind": "Condition",
        "passingValue": false,
        "selections": [
          {
            "alias": "channelHome",
            "args": (v3/*: any*/),
            "concreteType": "User",
            "kind": "LinkedField",
            "name": "user",
            "plural": false,
            "selections": [
              (v5/*: any*/),
              {
                "alias": null,
                "args": null,
                "kind": "ScalarField",
                "name": "bannerImageURL",
                "storageKey": null
              },
              (v32/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "User",
                "kind": "LinkedField",
                "name": "hosting",
                "plural": false,
                "selections": [
                  (v4/*: any*/),
                  (v5/*: any*/),
                  (v6/*: any*/),
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "Stream",
                    "kind": "LinkedField",
                    "name": "stream",
                    "plural": false,
                    "selections": [
                      (v4/*: any*/),
                      (v33/*: any*/),
                      (v11/*: any*/),
                      (v27/*: any*/)
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "Broadcast",
                "kind": "LinkedField",
                "name": "lastBroadcast",
                "plural": false,
                "selections": [
                  (v4/*: any*/),
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "startedAt",
                    "storageKey": null
                  },
                  (v34/*: any*/)
                ],
                "storageKey": null
              },
              {
                "alias": null,
                "args": null,
                "concreteType": "Stream",
                "kind": "LinkedField",
                "name": "stream",
                "plural": false,
                "selections": [
                  (v4/*: any*/),
                  (v9/*: any*/),
                  (v34/*: any*/),
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "type",
                    "storageKey": null
                  },
                  (v35/*: any*/),
                  (v33/*: any*/),
                  (v11/*: any*/)
                ],
                "storageKey": null
              },
              (v6/*: any*/),
              (v7/*: any*/),
              {
                "alias": null,
                "args": [
                  {
                    "kind": "Literal",
                    "name": "first",
                    "value": 30
                  }
                ],
                "concreteType": "VideoConnection",
                "kind": "LinkedField",
                "name": "videos",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "VideoEdge",
                    "kind": "LinkedField",
                    "name": "edges",
                    "plural": true,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "Video",
                        "kind": "LinkedField",
                        "name": "node",
                        "plural": false,
                        "selections": [
                          (v4/*: any*/),
                          (v34/*: any*/)
                        ],
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": "videos(first:30)"
              },
              (v19/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "Channel",
                "kind": "LinkedField",
                "name": "channel",
                "plural": false,
                "selections": [
                  (v4/*: any*/),
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "SocialMedia",
                    "kind": "LinkedField",
                    "name": "socialMedias",
                    "plural": true,
                    "selections": [
                      (v4/*: any*/),
                      (v12/*: any*/),
                      (v8/*: any*/),
                      (v31/*: any*/)
                    ],
                    "storageKey": null
                  },
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "ChannelHome",
                    "kind": "LinkedField",
                    "name": "home",
                    "plural": false,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "ChannelHomeShelves",
                        "kind": "LinkedField",
                        "name": "shelves",
                        "plural": false,
                        "selections": [
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": "ChannelHomeCategoryShelf",
                            "kind": "LinkedField",
                            "name": "categoryShelf",
                            "plural": false,
                            "selections": [
                              {
                                "alias": null,
                                "args": null,
                                "concreteType": "ChannelHomeCategoryShelfEdge",
                                "kind": "LinkedField",
                                "name": "edges",
                                "plural": true,
                                "selections": [
                                  {
                                    "alias": null,
                                    "args": null,
                                    "concreteType": "Game",
                                    "kind": "LinkedField",
                                    "name": "node",
                                    "plural": false,
                                    "selections": [
                                      (v4/*: any*/),
                                      (v12/*: any*/),
                                      (v6/*: any*/),
                                      (v35/*: any*/),
                                      {
                                        "alias": null,
                                        "args": null,
                                        "kind": "ScalarField",
                                        "name": "boxArtURL",
                                        "storageKey": null
                                      }
                                    ],
                                    "storageKey": null
                                  }
                                ],
                                "storageKey": null
                              }
                            ],
                            "storageKey": null
                          },
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": "ChannelHomeStreamerShelf",
                            "kind": "LinkedField",
                            "name": "streamerShelf",
                            "plural": false,
                            "selections": [
                              {
                                "alias": null,
                                "args": null,
                                "concreteType": "ChannelHomeStreamerShelfEdge",
                                "kind": "LinkedField",
                                "name": "edges",
                                "plural": true,
                                "selections": [
                                  {
                                    "alias": null,
                                    "args": null,
                                    "concreteType": "User",
                                    "kind": "LinkedField",
                                    "name": "node",
                                    "plural": false,
                                    "selections": [
                                      (v4/*: any*/),
                                      (v6/*: any*/),
                                      (v5/*: any*/),
                                      {
                                        "alias": null,
                                        "args": null,
                                        "concreteType": "Stream",
                                        "kind": "LinkedField",
                                        "name": "stream",
                                        "plural": false,
                                        "selections": [
                                          (v35/*: any*/),
                                          (v4/*: any*/)
                                        ],
                                        "storageKey": null
                                      },
                                      (v32/*: any*/),
                                      (v36/*: any*/)
                                    ],
                                    "storageKey": null
                                  }
                                ],
                                "storageKey": null
                              }
                            ],
                            "storageKey": null
                          }
                        ],
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              (v36/*: any*/),
              {
                "alias": null,
                "args": null,
                "concreteType": "FollowerConnection",
                "kind": "LinkedField",
                "name": "followers",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "kind": "ScalarField",
                    "name": "totalCount",
                    "storageKey": null
                  }
                ],
                "storageKey": null
              },
              (v4/*: any*/),
              {
                "alias": "archives",
                "args": (v16/*: any*/),
                "concreteType": "VideoConnection",
                "kind": "LinkedField",
                "name": "videos",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "VideoEdge",
                    "kind": "LinkedField",
                    "name": "edges",
                    "plural": true,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "Video",
                        "kind": "LinkedField",
                        "name": "node",
                        "plural": false,
                        "selections": [
                          (v4/*: any*/),
                          (v8/*: any*/),
                          (v37/*: any*/),
                          (v28/*: any*/),
                          {
                            "alias": null,
                            "args": null,
                            "kind": "ScalarField",
                            "name": "publishedAt",
                            "storageKey": null
                          },
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": "Game",
                            "kind": "LinkedField",
                            "name": "game",
                            "plural": false,
                            "selections": [
                              (v12/*: any*/),
                              (v4/*: any*/)
                            ],
                            "storageKey": null
                          }
                        ],
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": "videos(first:1,sort:\"TIME\",type:\"ARCHIVE\")"
              },
              {
                "alias": null,
                "args": (v17/*: any*/),
                "concreteType": "VideoShelfConnection",
                "kind": "LinkedField",
                "name": "videoShelves",
                "plural": false,
                "selections": [
                  {
                    "alias": null,
                    "args": null,
                    "concreteType": "VideoShelfEdge",
                    "kind": "LinkedField",
                    "name": "edges",
                    "plural": true,
                    "selections": [
                      {
                        "alias": null,
                        "args": null,
                        "concreteType": "VideoShelf",
                        "kind": "LinkedField",
                        "name": "node",
                        "plural": false,
                        "selections": [
                          (v8/*: any*/),
                          {
                            "alias": null,
                            "args": null,
                            "concreteType": null,
                            "kind": "LinkedField",
                            "name": "items",
                            "plural": true,
                            "selections": [
                              {
                                "alias": null,
                                "args": null,
                                "kind": "ScalarField",
                                "name": "__typename",
                                "storageKey": null
                              },
                              {
                                "kind": "TypeDiscriminator",
                                "abstractKey": "__isVideoShelfItem"
                              },
                              {
                                "kind": "InlineFragment",
                                "selections": [
                                  (v4/*: any*/),
                                  (v38/*: any*/),
                                  {
                                    "alias": null,
                                    "args": null,
                                    "concreteType": "User",
                                    "kind": "LinkedField",
                                    "name": "broadcaster",
                                    "plural": false,
                                    "selections": [
                                      (v5/*: any*/),
                                      (v4/*: any*/)
                                    ],
                                    "storageKey": null
                                  },
                                  {
                                    "alias": "clipCreatedAt",
                                    "args": null,
                                    "kind": "ScalarField",
                                    "name": "createdAt",
                                    "storageKey": null
                                  },
                                  {
                                    "alias": null,
                                    "args": null,
                                    "kind": "ScalarField",
                                    "name": "durationSeconds",
                                    "storageKey": null
                                  },
                                  {
                                    "alias": null,
                                    "args": null,
                                    "kind": "ScalarField",
                                    "name": "slug",
                                    "storageKey": null
                                  },
                                  {
                                    "alias": null,
                                    "args": null,
                                    "kind": "ScalarField",
                                    "name": "thumbnailURL",
                                    "storageKey": null
                                  },
                                  {
                                    "alias": "clipTitle",
                                    "args": null,
                                    "kind": "ScalarField",
                                    "name": "title",
                                    "storageKey": null
                                  },
                                  {
                                    "alias": "clipViewCount",
                                    "args": null,
                                    "kind": "ScalarField",
                                    "name": "viewCount",
                                    "storageKey": null
                                  }
                                ],
                                "type": "Clip",
                                "abstractKey": null
                              },
                              {
                                "kind": "InlineFragment",
                                "selections": [
                                  (v4/*: any*/),
                                  (v38/*: any*/),
                                  (v9/*: any*/),
                                  {
                                    "alias": null,
                                    "args": null,
                                    "kind": "ScalarField",
                                    "name": "lengthSeconds",
                                    "storageKey": null
                                  },
                                  (v28/*: any*/),
                                  (v8/*: any*/),
                                  (v37/*: any*/)
                                ],
                                "type": "Video",
                                "abstractKey": null
                              }
                            ],
                            "storageKey": null
                          },
                          (v4/*: any*/)
                        ],
                        "storageKey": null
                      }
                    ],
                    "storageKey": null
                  }
                ],
                "storageKey": "videoShelves(first:1)"
              }
            ],
            "storageKey": null
          }
        ]
      }
    ]
  },
  "params": {
    "cacheID": "3fc3b7de4607d1a14432238ac8bf6b4c",
    "id": null,
    "metadata": {},
    "name": "Channel_Query",
    "operationKind": "query",
    "text": "query Channel_Query(\n  $login: String!\n  $isBrowser: Boolean!\n  $url: String!\n) {\n  channel: user(login: $login) {\n    ...StreamPlayer_channel\n    ...StreamInfoBox_channel\n    id\n    login\n    displayName\n    description\n    broadcastSettings {\n      id\n      title\n      game {\n        displayName\n        id\n      }\n    }\n    stream {\n      id\n      createdAt\n      height\n      previewImageURL\n      game {\n        id\n        name\n      }\n    }\n    hosting {\n      id\n      login\n      stream {\n        id\n        game {\n          id\n          name\n        }\n      }\n    }\n  }\n  channelHome: user(login: $login) @skip(if: $isBrowser) {\n    ...ChannelLayout_user\n    id\n    login\n    displayName\n    stream {\n      id\n      ...FeaturedSection_stream\n    }\n    hosting {\n      stream {\n        ...FeaturedSection_hosting\n        id\n      }\n      id\n    }\n    archives: videos(first: 1, type: ARCHIVE, sort: TIME) {\n      edges {\n        node {\n          ...FeaturedSection_archives\n          id\n        }\n      }\n    }\n    videoShelves(first: 1) {\n      edges {\n        node {\n          title\n          items {\n            __typename\n            ...VideoShelf_items\n          }\n          id\n        }\n      }\n    }\n    channel {\n      home {\n        shelves {\n          categoryShelf {\n            edges {\n              node {\n                ...CategoryShelf_items\n                id\n              }\n            }\n          }\n          streamerShelf {\n            edges {\n              node {\n                ...StreamerShelf_items\n                id\n              }\n            }\n          }\n        }\n      }\n      id\n    }\n  }\n  ...PageHead_query\n}\n\nfragment CategoryShelf_items on Game {\n  id\n  name\n  ...GameCard_game\n}\n\nfragment ChannelCover_user on User {\n  login\n  bannerImageURL\n  primaryColorHex\n}\n\nfragment ChannelDescription_user on User {\n  login\n  displayName\n  description\n  lastBroadcast {\n    game {\n      displayName\n      id\n    }\n    id\n  }\n  videos(first: 30) {\n    edges {\n      node {\n        id\n        game {\n          id\n          displayName\n        }\n      }\n    }\n  }\n}\n\nfragment ChannelFeaturedCardStream_stream on Stream {\n  id\n  broadcaster {\n    broadcastSettings {\n      title\n      id\n    }\n    id\n    login\n  }\n  previewImageURL\n  game {\n    displayName\n    id\n  }\n}\n\nfragment ChannelFeaturedCardVideo_video on Video {\n  id\n  title\n  viewCount\n  previewThumbnailURL\n  publishedAt\n  game {\n    name\n    id\n  }\n}\n\nfragment ChannelLayout_user on User {\n  ...ChannelCover_user\n  ...ChannelProfileInfo_user\n  id\n  login\n}\n\nfragment ChannelName_user on User {\n  displayName\n  login\n  roles {\n    isPartner\n  }\n}\n\nfragment ChannelProfileInfo_user on User {\n  ...ChannelStatus_user\n  ...ChannelDescription_user\n  ...ChannelName_user\n  ...SocialMediaLinks_user\n  profileImageURL(width: 150)\n  login\n  displayName\n  primaryColorHex\n  followers {\n    totalCount\n  }\n  stream {\n    id\n  }\n}\n\nfragment ChannelStatus_user on User {\n  hosting {\n    id\n    login\n    displayName\n  }\n  lastBroadcast {\n    id\n    startedAt\n    game {\n      id\n      displayName\n    }\n  }\n  stream {\n    id\n    createdAt\n    game {\n      id\n      displayName\n    }\n    type\n    viewersCount\n  }\n}\n\nfragment FeaturedSection_archives on Video {\n  ...ChannelFeaturedCardVideo_video\n}\n\nfragment FeaturedSection_hosting on Stream {\n  ...ChannelFeaturedCardStream_stream\n}\n\nfragment FeaturedSection_stream on Stream {\n  ...ChannelFeaturedCardStream_stream\n}\n\nfragment GameCard_game on Game {\n  name\n  id\n  displayName\n  viewersCount\n  boxArtURL\n}\n\nfragment PageHead_query on Query {\n  urlMetadata(url: $url) {\n    title\n    metatags {\n      name\n      attributes {\n        key\n        value\n      }\n    }\n    jsonld\n    share {\n      title\n      text\n      url\n    }\n  }\n}\n\nfragment SocialMediaLinks_user on User {\n  channel {\n    id\n    socialMedias {\n      id\n      name\n      title\n      url\n    }\n  }\n}\n\nfragment StreamInfoBox_channel on User {\n  id\n  login\n  displayName\n  profileImageURL(width: 50)\n  stream {\n    id\n    game {\n      name\n      id\n    }\n    ...TagList_stream\n  }\n  hosting {\n    id\n    login\n    displayName\n    profileImageURL(width: 50)\n    stream {\n      id\n      game {\n        name\n        id\n      }\n      ...TagList_stream\n    }\n  }\n}\n\nfragment StreamPlayer_channel on User {\n  id\n  displayName\n  login\n  offlineImageURL\n  roles {\n    isPartner\n  }\n  self {\n    subscriptionBenefit {\n      id\n    }\n  }\n  stream {\n    id\n    game {\n      id\n      name\n    }\n    previewImageURL\n    restrictionType\n    self {\n      canWatch\n    }\n    archiveVideo {\n      id\n    }\n  }\n  broadcastSettings {\n    isMature\n    id\n  }\n  videos(sort: TIME, first: 3) {\n    edges {\n      node {\n        id\n        previewThumbnailURL\n        title\n        status\n      }\n    }\n  }\n  hosting {\n    id\n    displayName\n    login\n    offlineImageURL\n    roles {\n      isPartner\n    }\n    self {\n      subscriptionBenefit {\n        id\n      }\n    }\n    stream {\n      id\n      game {\n        id\n        name\n      }\n      previewImageURL\n      restrictionType\n      self {\n        canWatch\n      }\n      archiveVideo {\n        id\n      }\n    }\n    broadcastSettings {\n      isMature\n      id\n    }\n    videos(sort: TIME, first: 3) {\n      edges {\n        node {\n          id\n          previewThumbnailURL\n          title\n          status\n        }\n      }\n    }\n  }\n}\n\nfragment StreamerShelf_items on User {\n  id\n  ...UserCard_user\n}\n\nfragment TagLink_tag on Tag {\n  id\n  tagName\n  localizedDescription\n  localizedName\n}\n\nfragment TagList_stream on Stream {\n  streamTags: tags {\n    ...TagLink_tag\n    id\n  }\n}\n\nfragment UserCard_user on User {\n  id\n  displayName\n  login\n  stream {\n    viewersCount\n    id\n  }\n  primaryColorHex\n  profileImageURL(width: 150)\n}\n\nfragment VideoShelfClip_clip on Clip {\n  id\n  broadcaster {\n    login\n    id\n  }\n  clipCreatedAt: createdAt\n  durationSeconds\n  game {\n    name\n    displayName\n    id\n  }\n  slug\n  thumbnailURL\n  clipTitle: title\n  clipViewCount: viewCount\n}\n\nfragment VideoShelfVideo_video on Video {\n  id\n  createdAt\n  lengthSeconds\n  game {\n    name\n    displayName\n    id\n  }\n  previewThumbnailURL\n  title\n  viewCount\n}\n\nfragment VideoShelf_items on VideoShelfItem {\n  __isVideoShelfItem: __typename\n  __typename\n  ... on Clip {\n    id\n    game {\n      name\n      id\n    }\n    ...VideoShelfClip_clip\n  }\n  ... on Video {\n    id\n    game {\n      name\n      id\n    }\n    ...VideoShelfVideo_video\n  }\n}\n"
  }
};
})();
(node as any).hash = 'da4a2fb5f3f46e782e99888a4893ca75';
export default node;
