import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import styled from 'styled-components';
import { Color, Layout, TextType, Title, Typeset } from 'twitch-core-ui';
import { PanelImage } from './PanelImage';
import type { DefaultPanel_panel } from './__generated__/DefaultPanel_panel.graphql';

type DefaultPanelProps = {
  panel: DefaultPanel_panel;
};

const ScLayout = styled(Layout)`
  min-width: 32rem;
  width: 32rem;
`;

// istanbul ignore next: trivial
export const DefaultPanelBase: FC<DefaultPanelProps> = ({ panel }) => {
  return (
    <ScLayout margin={{ bottom: 2 }}>
      {panel.title && <Title type={TextType.H3}>{panel.title}</Title>}
      {panel.imageURL && (
        <PanelImage imageURL={panel.imageURL} linkURL={panel.linkURL} />
      )}
      {panel.description && (
        <Layout color={Color.Base} margin={{ top: 1 }}>
          <Typeset>{panel.description}</Typeset>
        </Layout>
      )}
    </ScLayout>
  );
};

DefaultPanelBase.displayName = 'DefaultPanel';

export const DefaultPanel = createFragmentContainer(DefaultPanelBase, {
  panel: graphql`
    fragment DefaultPanel_panel on DefaultPanel {
      id
      title
      linkURL
      imageURL
      description
    }
  `,
});
