import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { CoreLink } from 'twitch-core-ui';
import { PanelImage } from './PanelImage';

describe(PanelImage, () => {
  const setup = createShallowWrapperFactory(PanelImage, () => {
    return {
      imageURL:
        'https://panels-images.twitch.tv/panel-24666044-image-71435227-14b5-47b0-8259-a3af9685228e',
      linkURL: null,
    };
  });

  it('renders correctly', () => {
    const { wrapper } = setup();
    expect(wrapper).not.toBeEmptyRender();
  });

  it('wraps image with a link when a linkURL is passed', () => {
    const { wrapper } = setup({
      linkURL: 'https://example.com',
    });

    expect(wrapper.find(CoreLink)).toHaveLength(1);
  });
});
