import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { CoreLink } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../routing';

type PanelImageProps = {
  imageURL: string;
  linkURL: string | null;
};

export const PanelImage: FC<PanelImageProps> = (props) => {
  const { formatMessage } = useIntl();

  let image = (
    <img
      alt={formatMessage('Panel Content', 'ChannelAboutPagePanelImage')}
      src={props.imageURL}
    />
  );

  if (props.linkURL) {
    image = (
      <CoreLink
        linkTo="/deferToRenderLink"
        renderLink={renderTachyonLink({
          route: RouteName.External,
          routeParams: { href: props.linkURL },
        })}
        targetBlank
      >
        {image}
      </CoreLink>
    );
  }

  return image;
};

PanelImage.displayName = 'PanelImage';
