import { datatype, internet, lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ChannelEmptyState } from '../../common';
import { DefaultPanel } from './DefaultPanel';
import { ChannelAboutPage } from '.';

describe(ChannelAboutPage, () => {
  const setup = createShallowWrapperFactory(ChannelAboutPage, () => {
    const login = lorem.word().toLowerCase();

    return {
      ' $fragmentRefs': {
        PageHead_query: true,
      },
      channel: {
        ' $fragmentRefs': {
          ChannelLayout_user: true,
          PageHead_query: true,
        },
        id: datatype.uuid(),
        login,
        panels: [],
        stream: {
          id: datatype.uuid(),
        },
      },
      loading: false,
      queryVariables: {
        login,
        url: internet.url(),
      },
    };
  });

  it('renders empty state when no panels are returned', () => {
    const { wrapper } = setup({ channel: { panels: undefined } });
    expect(wrapper.find(ChannelEmptyState)).toHaveLength(1);
  });

  it('renders empty state when no default panels are returned', () => {
    const { wrapper } = setup({
      channel: {
        panels: [
          { id: datatype.uuid(), type: 'EXTENSION' },
          null,
          { id: datatype.uuid(), type: 'EXTENSION' },
        ],
      },
    });
    expect(wrapper.find(ChannelEmptyState)).toHaveLength(1);
  });

  it('renders default panels', () => {
    const { wrapper } = setup({
      channel: {
        panels: [
          { id: datatype.uuid(), type: 'EXTENSION' },
          null,
          { id: datatype.uuid(), type: 'EXTENSION' },
          { id: datatype.uuid(), type: 'DEFAULT' },
          { id: datatype.uuid(), type: 'DEFAULT' },
          { id: datatype.uuid(), type: 'DEFAULT' },
        ],
      },
    });

    expect(wrapper.find(DefaultPanel)).toHaveLength(3);
  });
});
