import { datatype } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ChannelEmptyState } from '../../../common';
import { ClipListBase, ScInfiniteList as InfiniteList } from '.';

jest.mock('../../../common', () => ({
  ...jest.requireActual('../../../common'),
  ClipCard: () => 'ClipCard',
}));

describe(ClipListBase, () => {
  const setup = createShallowWrapperFactory(ClipListBase, () => ({
    period: 'LAST_MONTH',
    relay: { refetch: jest.fn() } as any,
    user: {
      ' $refType': 'ClipList_user',
      clips: {
        edges: [
          {
            cursor: 1,
            node: { ' $fragmentRefs': { ClipCard_clip: true }, id: 'clip-0' },
          },
        ],
        pageInfo: { hasNextPage: true },
      },
      id: datatype.uuid(),
      login: 'arthas',
    },
  }));

  it('renders list', () => {
    const { wrapper } = setup();
    expect(wrapper.find(InfiniteList)).toExist();
  });

  it('renders empty state when there are no edges', () => {
    const { wrapper } = setup({
      user: {
        clips: {
          edges: [],
          pageInfo: { hasNextPage: false },
        },
      },
    });

    expect(wrapper.find(ChannelEmptyState)).toExist();
    expect(wrapper.find(InfiniteList)).not.toExist();
  });
});
