import { graphql } from 'react-relay/hooks';
import type { ChannelPathParameters } from 'tachyon-page-utils';
import {
  channelClipsPageviewTracking,
  channelPathGetInitialProps,
} from 'tachyon-page-utils';
import { flattenHeaderOrParam } from 'tachyon-utils';
import { CHANNEL_CLIPS_FILTER_QUERY_PARAM_KEY } from '../../../config';
import { pageHeadQueryVariables } from '../../growth';
import { ChannelLayout } from '../../layouts';
import type { PageWithQueryProps, TomorrowPage } from '../types';
import { ClipList } from './ClipList';
import type {
  ChannelClipsPage_QueryResponse,
  ChannelClipsPage_QueryVariables,
} from './__generated__/ChannelClipsPage_Query.graphql';
import { CLIP_LIST_LOAD_MORE_LIMIT, getClipsPeriod } from './utils';

type ChannelClipsPageInitialProps = {
  queryVariables: ChannelClipsPage_QueryVariables;
};

type ChannelClipsPagePathParameters = ChannelPathParameters & {
  [CHANNEL_CLIPS_FILTER_QUERY_PARAM_KEY]?: string;
};

type ChannelClipsPageProps = PageWithQueryProps<
  ChannelClipsPage_QueryResponse,
  ChannelClipsPageInitialProps
>;

export const ChannelClipsPage: TomorrowPage<
  ChannelClipsPageInitialProps,
  ChannelClipsPageProps,
  ChannelClipsPagePathParameters
> = ({ channel, loading, queryVariables }) => {
  return (
    <ChannelLayout
      loading={loading}
      login={queryVariables.login}
      user={channel}
    >
      {channel && <ClipList period={queryVariables.period} user={channel} />}
    </ChannelLayout>
  );
};
ChannelClipsPage.displayName = 'ChannelClipsPage';
ChannelClipsPage.pageviewTracking = channelClipsPageviewTracking;
// TODO: verify non-js interactivity after dev
ChannelClipsPage.requiresJsForInteractivity = false;
ChannelClipsPage.handlesLoading = true;
ChannelClipsPage.getInitialProps = (ctx) =>
  channelPathGetInitialProps(ctx, {
    ...pageHeadQueryVariables(ctx),
    cursor: null,
    limit: CLIP_LIST_LOAD_MORE_LIMIT,
    period: getClipsPeriod(
      flattenHeaderOrParam(ctx.query[CHANNEL_CLIPS_FILTER_QUERY_PARAM_KEY]),
    ),
  });

ChannelClipsPage.query = graphql`
  query ChannelClipsPage_Query(
    $login: String!
    $period: ClipsPeriod!
    $cursor: Cursor
    $limit: Int!
    $url: String!
  ) {
    channel: user(login: $login) {
      ...ChannelLayout_user
      ...ClipList_user

      id
      login
      stream {
        id
      }
    }
    ...PageHead_query
  }
`;
