import { datatype, internet, lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ChannelClipsPage } from '.';

describe(ChannelClipsPage, () => {
  const setup = createShallowWrapperFactory(ChannelClipsPage, () => {
    const login = lorem.word().toLowerCase();

    return {
      ' $fragmentRefs': {
        PageHead_query: true,
      },
      channel: {
        ' $fragmentRefs': {
          ChannelLayout_user: true,
          ClipList_user: true,
        },
        id: datatype.uuid(),
        login,
        stream: null,
      },
      loading: false,
      queryVariables: {
        limit: 10,
        login,
        period: 'LAST_MONTH',
        url: internet.url(),
      },
    };
  });

  it('renders correctly', () => {
    const { wrapper } = setup();
    expect(wrapper.find(ChannelClipsPage)).not.toBeEmptyRender();
  });
});
