import { exhaustedCase } from 'tachyon-utils';
import type { TwitchIntl } from 'twitch-intl';
import type { ClipsPeriod } from '../__generated__/ChannelClipsPage_Query.graphql';

export type ClipsFilter = '7d' | '24h' | '30d' | 'all';

export const CLIP_LIST_LOAD_MORE_LIMIT = 20;
export const CLIP_LIST_PAGE_SIZE = 10;

// istanbul ignore next: trivial
export const getClipsFilter = (period: ClipsPeriod): ClipsFilter => {
  switch (period) {
    case 'ALL_TIME':
      return 'all';
    case 'LAST_DAY':
      return '24h';
    case 'LAST_MONTH':
      return '30d';
    case 'LAST_WEEK':
      return '7d';
    default:
      return exhaustedCase(period, '30d');
  }
};

// istanbul ignore next: trivial
export const getClipsPeriod = (filter: string | undefined): ClipsPeriod => {
  switch (filter) {
    case '7d':
      return 'LAST_WEEK';
    case '24h':
      return 'LAST_DAY';
    case '30d':
      return 'LAST_MONTH';
    case 'all':
      return 'ALL_TIME';
    default:
      return 'LAST_MONTH';
  }
};

// istanbul ignore next: trivial
export const getListTitle = (
  { formatMessage }: TwitchIntl,
  period: ClipsPeriod,
): string => {
  switch (period) {
    case 'ALL_TIME':
      return formatMessage('Popular - All time', 'ChannelClipsPage');
    case 'LAST_DAY':
      return formatMessage('Popular - 24 Hours', 'ChannelClipsPage');
    case 'LAST_MONTH':
      return formatMessage('Popular - 30 Days', 'ChannelClipsPage');
    case 'LAST_WEEK':
      return formatMessage('Popular - 7 Days', 'ChannelClipsPage');
    default:
      return exhaustedCase(period, '');
  }
};

// istanbul ignore next: trivial
export const getFilterLabel = (
  { formatMessage }: TwitchIntl,
  period: ClipsPeriod,
): string => {
  switch (period) {
    case 'ALL_TIME':
      return formatMessage('Show all', 'ChannelClipsPage');
    case 'LAST_DAY':
      return formatMessage('24 Hours', 'ChannelClipsPage');
    case 'LAST_MONTH':
      return formatMessage('30 Days', 'ChannelClipsPage');
    case 'LAST_WEEK':
      return formatMessage('7 Days', 'ChannelClipsPage');
    default:
      return exhaustedCase(period, '');
  }
};

// istanbul ignore next: trivial
export const getEmptyStateTitle = (
  { formatMessage }: TwitchIntl,
  period: ClipsPeriod,
): string => {
  switch (period) {
    case 'ALL_TIME':
      return formatMessage('This channel has no clips', 'ChannelClipsPage');
    case 'LAST_DAY':
      return formatMessage(
        'This channel has no clips created in the last 24 Hours',
        'ChannelClipsPage',
      );
    case 'LAST_MONTH':
      return formatMessage(
        'This channel has no clips created in the last 30 Days',
        'ChannelClipsPage',
      );
    case 'LAST_WEEK':
      return formatMessage(
        'This channel has no clips created in the last 7 Days',
        'ChannelClipsPage',
      );
    default:
      return exhaustedCase(period, '');
  }
};
