import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { getBoxArtSrcAndSrcSet } from 'tachyon-more-ui';
import { getGameDisplayName } from 'tachyon-utils';
import {
  AspectRatio,
  CardImage,
  MediaCard,
  MediaCardImage,
  MediaCardMeta,
  MediaCardTitle,
} from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../routing';
import { CardLink } from '../../../common';
import type { GameCard_game } from './__generated__/GameCard_game.graphql';

type GameCardProps = {
  game: GameCard_game;
  onClick: () => void;
  onDisplay: () => void;
};

// istanbul ignore next: trivial
export const GameCardBase: FC<GameCardProps> = ({
  game,
  onClick,
  onDisplay,
}) => {
  return (
    <CardLink
      linkTo="/deferToRenderLink"
      onClick={onClick}
      onImpression={onDisplay}
      renderLink={renderTachyonLink({
        route: RouteName.GameDirectory,
        routeParams: { gameAlias: game.name },
      })}
    >
      <MediaCard
        image={
          <MediaCardImage
            image={
              <CardImage
                alt=""
                aspect={AspectRatio.BoxArt}
                {...getBoxArtSrcAndSrcSet(game.boxArtURL)}
              />
            }
            ratio={AspectRatio.BoxArt}
          />
        }
        meta={
          <MediaCardMeta
            title={<MediaCardTitle>{getGameDisplayName(game)}</MediaCardTitle>}
          />
        }
      />
    </CardLink>
  );
};

GameCardBase.displayName = 'GameCard';

export const GameCard = createFragmentContainer(GameCardBase, {
  game: graphql`
    fragment GameCard_game on Game {
      name
      id
      name
      displayName
      viewersCount
      boxArtURL
    }
  `,
});
