import { datatype } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { GameCard } from './GameCard';
import type { CategoryShelf_items } from './__generated__/CategoryShelf_items.graphql';
import { CategoryShelfBase } from '.';

const mockOnChannelPageItemClick = jest.fn();
const mockOnChannelPageItemDisplay = jest.fn();

jest.mock('tachyon-discovery', () => ({
  ...jest.requireActual('tachyon-discovery'),
  useDiscoveryTracking: () => ({
    onChannelPageItemClick: mockOnChannelPageItemClick,
    onChannelPageItemDisplay: mockOnChannelPageItemDisplay,
  }),
}));

type CategoryShelfEdge = CategoryShelf_items[0];

const shelf = (id: string): CategoryShelfEdge => ({
  ' $fragmentRefs': { GameCard_game: true },
  ' $refType': 'CategoryShelf_items',
  id,
  name: id,
});

describe(CategoryShelfBase, () => {
  const setup = createShallowWrapperFactory(CategoryShelfBase, () => ({
    items: [shelf('shelf-0')],
    user: {
      displayName: 'Arthas',
      id: datatype.uuid(),
      login: 'arthas',
    },
  }));

  it('renders category cards', () => {
    const { wrapper } = setup({
      items: [
        shelf('game-1'),
        shelf('game-2'),
        shelf('game-3'),
        shelf('game-4'),
        shelf('game-5'),
        shelf('game-6'),
        shelf('game-7'),
      ],
    });

    expect(wrapper.find(GameCard)).toExist();
  });

  it('calls tracking events', () => {
    const { wrapper } = setup({
      items: [shelf('game-1')],
    });

    const gameCard = wrapper.find(GameCard);
    gameCard.simulate('click');
    expect(mockOnChannelPageItemClick).toHaveBeenCalled();

    gameCard.prop('onDisplay')();
    expect(mockOnChannelPageItemDisplay).toHaveBeenCalled();
  });
});
