import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import {
  ChannelFeaturedCardStream,
  ChannelFeaturedCardVideo,
} from '../../../common';
import type { FeaturedSection_archives } from './__generated__/FeaturedSection_archives.graphql';
import type { FeaturedSection_hosting } from './__generated__/FeaturedSection_hosting.graphql';
import type { FeaturedSection_stream } from './__generated__/FeaturedSection_stream.graphql';

type FeaturedSectionProps = {
  archives: FeaturedSection_archives;
  hosting: FeaturedSection_hosting | null;
  stream: FeaturedSection_stream | null;
};

export const FeaturedSectionBase: FC<FeaturedSectionProps> = ({
  archives = [],
  hosting,
  stream,
}) => {
  if (hosting) {
    return <ChannelFeaturedCardStream stream={hosting} type="hosting" />;
  }

  if (stream) {
    return <ChannelFeaturedCardStream stream={stream} type="live" />;
  }

  if (archives.length > 0) {
    return (
      <ChannelFeaturedCardVideo type="past_broadcast" video={archives[0]} />
    );
  }

  return null;
};

FeaturedSectionBase.displayName = 'FeaturedSection';

export const FeaturedSection = createFragmentContainer(FeaturedSectionBase, {
  archives: graphql`
    fragment FeaturedSection_archives on Video @relay(plural: true) {
      ...ChannelFeaturedCardVideo_video
    }
  `,

  hosting: graphql`
    fragment FeaturedSection_hosting on Stream {
      ...ChannelFeaturedCardStream_stream
    }
  `,

  stream: graphql`
    fragment FeaturedSection_stream on Stream {
      ...ChannelFeaturedCardStream_stream
    }
  `,
});
