import { createShallowWrapperFactory } from 'tachyon-test-utils';
import {
  ChannelFeaturedCardStream,
  ChannelFeaturedCardVideo,
} from '../../../common';
import { FeaturedSectionBase } from '.';

describe(FeaturedSectionBase, () => {
  const setup = createShallowWrapperFactory(FeaturedSectionBase, () => {
    return {
      archives: [],
      hosting: null,
      stream: null,
    };
  });

  describe('when user has nothing', () => {
    it('renders empty', () => {
      const { wrapper } = setup();
      expect(wrapper).toBeEmptyRender();
    });
  });

  describe('when user is hosting', () => {
    it('renders a hosting featured card', () => {
      const { wrapper } = setup({
        hosting: {
          ' $fragmentRefs': {
            ChannelFeaturedCardStream_stream: true,
          },
        },
      });

      expect(wrapper.find(ChannelFeaturedCardStream).prop('type')).toBe(
        'hosting',
      );
    });
  });

  describe('when user is live', () => {
    it('renders a live featured card', () => {
      const { wrapper } = setup({
        stream: {
          ' $fragmentRefs': { ChannelFeaturedCardStream_stream: true },
        },
      });

      expect(wrapper.find(ChannelFeaturedCardStream).prop('type')).toBe('live');
    });
  });

  describe('when user is offline', () => {
    it('renders a live featured card', () => {
      const { wrapper } = setup({
        archives: [
          {
            ' $fragmentRefs': { ChannelFeaturedCardVideo_video: true },
          },
        ],
      });

      const mainCard = wrapper.find(ChannelFeaturedCardVideo);
      expect(mainCard.prop('type')).toBe('past_broadcast');
    });
  });
});
