import type { FC } from 'react';
import {
  Color,
  Display,
  Layout,
  Overflow,
  TextType,
  Title,
  TitleSize,
} from 'twitch-core-ui';

type HomeShelfProps = {
  title: string;
};

// istanbul ignore next: trivial
export const HomePageShelf: FC<HomeShelfProps> = ({ children, title }) => {
  return (
    <Layout color={Color.Base}>
      <Layout padding={{ bottom: 1 }}>
        <Title size={TitleSize.ExtraSmall} type={TextType.H3}>
          {title}
        </Title>
      </Layout>
      <Layout display={Display.Flex} overflow={Overflow.Scroll}>
        {children}
      </Layout>
    </Layout>
  );
};

HomePageShelf.displayName = 'HomePageShelf';
