import { datatype } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { UserCard } from './UserCard';
import type { StreamerShelf_items } from './__generated__/StreamerShelf_items.graphql';
import { StreamerShelfBase } from '.';

const mockOnChannelPageItemClick = jest.fn();
const mockOnChannelPageItemDisplay = jest.fn();

jest.mock('tachyon-discovery', () => ({
  ...jest.requireActual('tachyon-discovery'),
  useDiscoveryTracking: () => ({
    onChannelPageItemClick: mockOnChannelPageItemClick,
    onChannelPageItemDisplay: mockOnChannelPageItemDisplay,
  }),
}));

type StreamerShelfEdge = StreamerShelf_items[0];

const shelf = (id: string): StreamerShelfEdge => ({
  ' $fragmentRefs': { UserCard_user: true },
  ' $refType': 'StreamerShelf_items',
  id,
});

describe(StreamerShelfBase, () => {
  const setup = createShallowWrapperFactory(StreamerShelfBase, () => ({
    items: [shelf('streamer-0')],
    user: {
      displayName: 'Arthas Menethil',
      id: datatype.uuid(),
      login: 'arthas',
    },
  }));

  it('renders user cards', () => {
    const { wrapper } = setup({
      items: [
        shelf('streamer-1'),
        shelf('streamer-2'),
        shelf('streamer-3'),
        shelf('streamer-4'),
        shelf('streamer-5'),
        shelf('streamer-6'),
        shelf('streamer-7'),
      ],
    });

    expect(wrapper.find(UserCard)).toExist();
  });

  it('calls tracking events', () => {
    const { wrapper } = setup({
      items: [shelf('game-1')],
    });

    const userCard = wrapper.find(UserCard);
    userCard.simulate('click');
    expect(mockOnChannelPageItemClick).toHaveBeenCalled();

    userCard.prop('onDisplay')();
    expect(mockOnChannelPageItemDisplay).toHaveBeenCalled();
  });
});
