import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { CoreLinkType } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../routing';
import { CardLink } from '../../../common';
import { VideoShelfItem } from './VideoShelfItem';
import type { VideoShelfClip_clip } from './__generated__/VideoShelfClip_clip.graphql';

type VideoShelfClipProps = {
  clip: VideoShelfClip_clip;
  onClick: () => void;
  onDisplay: () => void;
};

// istanbul ignore next: trivial
export const VideoShelfClipBase: FC<VideoShelfClipProps> = ({
  clip,
  onClick,
  onDisplay,
}) => {
  if (!clip.broadcaster) {
    return null;
  }

  return (
    <CardLink
      linkTo="/deferToRenderLink"
      onClick={onClick}
      onImpression={onDisplay}
      renderLink={renderTachyonLink({
        route: RouteName.Clip,
        routeParams: { login: clip.broadcaster.login, slug: clip.slug },
      })}
      variant={CoreLinkType.Inherit}
    >
      <VideoShelfItem
        item={{
          createdAt: clip.clipCreatedAt,
          game: clip.game,
          lengthSeconds: clip.durationSeconds,
          previewThumbnailURL: clip.thumbnailURL,
          title: clip.clipTitle,
          viewCount: clip.clipViewCount,
        }}
      />
    </CardLink>
  );
};

VideoShelfClipBase.displayName = 'VideoShelfClip';

export const VideoShelfClip = createFragmentContainer(VideoShelfClipBase, {
  clip: graphql`
    fragment VideoShelfClip_clip on Clip {
      id
      broadcaster {
        login
      }
      clipCreatedAt: createdAt
      durationSeconds
      game {
        name
        displayName
      }
      id
      slug
      thumbnailURL
      clipTitle: title
      clipViewCount: viewCount
    }
  `,
});
