import type { FC } from 'react';
import { createFragmentContainer, graphql } from 'react-relay/legacy';
import { CoreLinkType } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../routing';
import { CardLink } from '../../../common';
import { VideoShelfItem } from './VideoShelfItem';
import type { VideoShelfVideo_video } from './__generated__/VideoShelfVideo_video.graphql';

type VideoShelfVideoProps = {
  onClick: () => void;
  onDisplay: () => void;
  video: VideoShelfVideo_video;
};

// istanbul ignore next: trivial
export const VideoShelfVideoBase: FC<VideoShelfVideoProps> = ({
  onClick,
  onDisplay,
  video,
}) => {
  return (
    <CardLink
      linkTo="/deferToRenderLink"
      onClick={onClick}
      onImpression={onDisplay}
      renderLink={renderTachyonLink({
        route: RouteName.Vod,
        routeParams: { videoID: video.id },
      })}
      variant={CoreLinkType.Inherit}
    >
      <VideoShelfItem item={video} />
    </CardLink>
  );
};

VideoShelfVideoBase.displayName = 'VideoShelfVideo';

export const VideoShelfVideo = createFragmentContainer(VideoShelfVideoBase, {
  video: graphql`
    fragment VideoShelfVideo_video on Video {
      id
      createdAt
      lengthSeconds
      game {
        name
        displayName
      }
      previewThumbnailURL
      title
      viewCount
    }
  `,
});
