import { datatype, lorem } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { VideoShelfClip } from './VideoShelfClip';
import { VideoShelfVideo } from './VideoShelfVideo';
import { VideoShelfBase } from '.';

const mockOnChannelPageItemClick = jest.fn();
const mockOnChannelPageItemDisplay = jest.fn();

jest.mock('tachyon-discovery', () => ({
  ...jest.requireActual('tachyon-discovery'),
  useDiscoveryTracking: () => ({
    onChannelPageItemClick: mockOnChannelPageItemClick,
    onChannelPageItemDisplay: mockOnChannelPageItemDisplay,
  }),
}));

describe(VideoShelfBase, () => {
  const setup = createShallowWrapperFactory(VideoShelfBase, () => ({
    items: [],
    title: 'shelf',
    user: {
      id: datatype.uuid(),
      login: lorem.word(),
    },
  }));

  it('renders a shelf with videos', () => {
    const { wrapper } = setup({
      items: [
        {
          ' $fragmentRefs': { VideoShelfVideo_video: true },
          __typename: 'Video',
          id: 'video-1',
        },
      ],
      title: 'video shelf',
    });

    expect(wrapper.find(VideoShelfVideo)).toHaveLength(1);
  });

  it('renders a shelf with clips', () => {
    const { wrapper } = setup({
      items: [
        {
          ' $fragmentRefs': { VideoShelfClip_clip: true },
          __typename: 'Clip',
          id: 'clip-1',
        },
      ],
      title: 'clip shelf',
    });

    expect(wrapper.find(VideoShelfClip)).toHaveLength(1);
  });

  it('calls video tracking events', () => {
    const { wrapper } = setup({
      items: [
        {
          ' $fragmentRefs': { VideoShelfVideo_video: true },
          __typename: 'Video',
          id: 'video-1',
        },
      ],
      title: 'video shelf',
    });

    const videoCard = wrapper.find(VideoShelfVideo);
    videoCard.simulate('click');
    expect(mockOnChannelPageItemClick).toHaveBeenCalled();
    videoCard.prop('onDisplay')();
    expect(mockOnChannelPageItemDisplay).toHaveBeenCalled();
  });

  it('calls clip tracking event call on item click', () => {
    const { wrapper } = setup({
      items: [
        {
          ' $fragmentRefs': { VideoShelfClip_clip: true },
          __typename: 'Clip',
          id: 'clip-1',
        },
      ],
      title: 'clip shelf',
    });

    const clipCard = wrapper.find(VideoShelfClip);
    clipCard.simulate('click');
    expect(mockOnChannelPageItemClick).toHaveBeenCalled();
    clipCard.prop('onDisplay')();
    expect(mockOnChannelPageItemDisplay).toHaveBeenCalled();
  });
});
