import { datatype, internet } from 'faker';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { ChannelEmptyState } from '../../common';
import { ChannelHomePage } from '.';

describe(ChannelHomePage, () => {
  const setup = createShallowWrapperFactory(ChannelHomePage, () => {
    return {
      ' $fragmentRefs': {
        PageHead_query: true,
      },
      channel: {
        ' $fragmentRefs': {
          ChannelLayout_user: true,
        },
        archives: {
          edges: [
            {
              node: {
                ' $fragmentRefs': {
                  FeaturedSection_archives: true,
                },
              },
            },
          ],
        },
        channel: {
          home: {
            shelves: {
              categoryShelf: {
                edges: [
                  {
                    node: {
                      ' $fragmentRefs': {
                        CategoryShelf_items: true,
                      },
                    },
                  },
                ],
              },
              streamerShelf: {
                edges: [
                  {
                    node: {
                      ' $fragmentRefs': {
                        StreamerShelf_items: true,
                      },
                    },
                  },
                ],
              },
            },
          },
        },
        displayName: 'Arthas Menethil',
        hosting: {
          stream: {
            ' $fragmentRefs': {
              FeaturedSection_hosting: true,
            },
          },
        },
        id: datatype.uuid(),
        login: 'arthas',
        stream: {
          ' $fragmentRefs': {
            FeaturedSection_stream: true,
          },
          id: datatype.uuid(),
        },
        videoShelves: {
          edges: [
            {
              node: {
                items: [
                  {
                    ' $fragmentRefs': {
                      VideoShelf_items: true,
                    },
                  },
                ],
                title: 'shelf',
              },
            },
          ],
        },
      },
      loading: false,
      queryVariables: {
        login: 'arthas',
        url: internet.url(),
      },
    };
  });

  it('renders correctly', () => {
    const { wrapper } = setup();
    expect(wrapper.find(ChannelHomePage)).not.toBeEmptyRender();
  });

  it('renders empty state', () => {
    const { wrapper } = setup({
      channel: {
        archives: null,
        channel: null,
        hosting: null,
        stream: null,
        videoShelves: null,
      },
    });

    expect(wrapper.find(ChannelEmptyState)).toExist();
  });
});
